/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.unix.SolarisLibc;
import oshi.software.os.unix.solaris.SolarisOperatingSystem;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;
import oshi.util.tuples.Quartet;

@ThreadSafe
final class SolarisCentralProcessor
extends AbstractCentralProcessor {
    private static final String KSTAT_SYSTEM_CPU = "kstat:/system/cpu/";
    private static final String INFO = "/info";
    private static final String SYS = "/sys";
    private static final String KSTAT_PM_CPU = "kstat:/pm/cpu/";
    private static final String PSTATE = "/pstate";
    private static final String CPU_INFO = "cpu_info";

    SolarisCentralProcessor() {
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        boolean bl = "64".equals(ExecutingCommand.getFirstAnswer("isainfo -b").trim());
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryProcessorId2(bl);
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        long l = 0L;
        try (Object object = KstatUtil.openChain();){
            LibKstat.Kstat kstat = ((KstatUtil.KstatChain)object).lookup(CPU_INFO, -1, null);
            if (kstat != null && ((KstatUtil.KstatChain)object).read(kstat)) {
                string = KstatUtil.dataLookupString(kstat, "vendor_id");
                string2 = KstatUtil.dataLookupString(kstat, "brand");
                string3 = KstatUtil.dataLookupString(kstat, "family");
                string4 = KstatUtil.dataLookupString(kstat, "model");
                string5 = KstatUtil.dataLookupString(kstat, "stepping");
                l = KstatUtil.dataLookupLong(kstat, "clock_MHz") * 1000000L;
            }
        }
        object = SolarisCentralProcessor.getProcessorID(string5, string4, string3);
        return new CentralProcessor.ProcessorIdentifier(string, string2, string3, string4, string5, (String)object, bl, l);
    }

    private static CentralProcessor.ProcessorIdentifier queryProcessorId2(boolean bl) {
        Object[] objectArray = KstatUtil.queryKstat2("kstat:/system/cpu/0/info", "vendor_id", "brand", "family", "model", "stepping", "clock_MHz");
        String string = objectArray[0] == null ? "" : (String)objectArray[0];
        String string2 = objectArray[1] == null ? "" : (String)objectArray[1];
        String string3 = objectArray[2] == null ? "" : objectArray[2].toString();
        String string4 = objectArray[3] == null ? "" : objectArray[3].toString();
        String string5 = objectArray[4] == null ? "" : objectArray[4].toString();
        long l = objectArray[5] == null ? 0L : (Long)objectArray[5];
        String string6 = SolarisCentralProcessor.getProcessorID(string5, string4, string3);
        return new CentralProcessor.ProcessorIdentifier(string, string2, string3, string4, string5, string6, bl, l);
    }

    @Override
    protected Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>, List<String>> initProcessorCounts() {
        Object object;
        Object object2;
        Object object3;
        List<CentralProcessor.LogicalProcessor> list;
        Map<Integer, Integer> map = SolarisCentralProcessor.mapNumaNodes();
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            list = SolarisCentralProcessor.initProcessorCounts2(map);
        } else {
            list = new ArrayList<CentralProcessor.LogicalProcessor>();
            object3 = KstatUtil.openChain();
            try {
                object2 = ((KstatUtil.KstatChain)object3).lookupAll(CPU_INFO, -1, null);
                object = object2.iterator();
                while (object.hasNext()) {
                    LibKstat.Kstat object4 = (LibKstat.Kstat)object.next();
                    if (object4 == null || !((KstatUtil.KstatChain)object3).read(object4)) continue;
                    int n = list.size();
                    String string = KstatUtil.dataLookupString(object4, "chip_id");
                    String string2 = KstatUtil.dataLookupString(object4, "core_id");
                    CentralProcessor.LogicalProcessor logicalProcessor = new CentralProcessor.LogicalProcessor(n, ParseUtil.parseIntOrDefault(string2, 0), ParseUtil.parseIntOrDefault(string, 0), map.getOrDefault(n, 0));
                    list.add(logicalProcessor);
                }
            }
            finally {
                if (object3 != null) {
                    ((KstatUtil.KstatChain)object3).close();
                }
            }
        }
        if (list.isEmpty()) {
            list.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        object3 = new HashMap();
        object2 = Pattern.compile(".* cpu(\\\\d+): ((ARM|AMD|Intel).+)");
        for (String string : ExecutingCommand.runNative("dmesg")) {
            Matcher matcher = ((Pattern)object2).matcher(string);
            if (!matcher.matches()) continue;
            int n = ParseUtil.parseIntOrDefault(matcher.group(1), 0);
            object3.put(n, matcher.group(2).trim());
        }
        if (object3.isEmpty()) {
            return new Quartet(list, null, null, Collections.emptyList());
        }
        object = ExecutingCommand.runNative("isainfo -x");
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, Object, Object>(list, this.createProcListFromDmesg(list, (Map<Integer, String>)object3), null, object);
    }

    private static List<CentralProcessor.LogicalProcessor> initProcessorCounts2(Map<Integer, Integer> map) {
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>();
        List<Object[]> list = KstatUtil.queryKstat2List(KSTAT_SYSTEM_CPU, INFO, "chip_id", "core_id");
        for (Object[] objectArray : list) {
            int n = arrayList.size();
            long l = objectArray[0] == null ? 0L : (Long)objectArray[0];
            long l2 = objectArray[1] == null ? 0L : (Long)objectArray[1];
            CentralProcessor.LogicalProcessor logicalProcessor = new CentralProcessor.LogicalProcessor(n, (int)l2, (int)l, map.getOrDefault(n, 0));
            arrayList.add(logicalProcessor);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        return arrayList;
    }

    private static Map<Integer, Integer> mapNumaNodes() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        for (String string : ExecutingCommand.runNative("lgrpinfo -c leaves")) {
            if (string.startsWith("lgroup")) {
                n = ParseUtil.getFirstIntValue(string);
                continue;
            }
            if (!string.contains("CPUs:") && !string.contains("CPU:")) continue;
            for (Integer n2 : ParseUtil.parseHyphenatedIntList(string.split(":")[1])) {
                hashMap.put(n2, n);
            }
        }
        return hashMap;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] lArray = new long[CentralProcessor.TickType.values().length];
        long[][] lArray2 = this.getProcessorCpuLoadTicks();
        int n = 0;
        while (n < lArray.length) {
            for (long[] lArray3 : lArray2) {
                int n2 = n;
                lArray[n2] = lArray[n2] + lArray3[n];
            }
            int n3 = n++;
            lArray[n3] = lArray[n3] / (long)lArray2.length;
        }
        return lArray;
    }

    @Override
    public long[] queryCurrentFreq() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryCurrentFreq2(this.getLogicalProcessorCount());
        }
        long[] lArray = new long[this.getLogicalProcessorCount()];
        Arrays.fill(lArray, -1L);
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            for (int i = 0; i < lArray.length; ++i) {
                for (LibKstat.Kstat kstat : kstatChain.lookupAll(CPU_INFO, i, null)) {
                    if (kstat == null || !kstatChain.read(kstat)) continue;
                    lArray[i] = KstatUtil.dataLookupLong(kstat, "current_clock_Hz");
                }
            }
        }
        return lArray;
    }

    private static long[] queryCurrentFreq2(int n) {
        long[] lArray = new long[n];
        Arrays.fill(lArray, -1L);
        List<Object[]> list = KstatUtil.queryKstat2List(KSTAT_SYSTEM_CPU, INFO, "current_clock_Hz");
        int n2 = -1;
        for (Object[] objectArray : list) {
            if (++n2 >= lArray.length) break;
            lArray[n2] = objectArray[0] == null ? -1L : (Long)objectArray[0];
        }
        return lArray;
    }

    @Override
    public long queryMaxFreq() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryMaxFreq2();
        }
        long l = -1L;
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            for (LibKstat.Kstat kstat : kstatChain.lookupAll(CPU_INFO, 0, null)) {
                String string;
                if (!kstatChain.read(kstat) || (string = KstatUtil.dataLookupString(kstat, "supported_frequencies_Hz")).isEmpty()) continue;
                for (String string2 : string.split(":")) {
                    long l2 = ParseUtil.parseLongOrDefault(string2, -1L);
                    if (l >= l2) continue;
                    l = l2;
                }
            }
        }
        return l;
    }

    private static long queryMaxFreq2() {
        long l = -1L;
        List<Object[]> list = KstatUtil.queryKstat2List(KSTAT_PM_CPU, PSTATE, "supported_frequencies");
        for (Object[] objectArray : list) {
            for (long l2 : objectArray[0] == null ? new long[]{} : (long[])objectArray[0]) {
                if (l2 <= l) continue;
                l = l2;
            }
        }
        return l;
    }

    @Override
    public double[] getSystemLoadAverage(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] dArray = new double[n];
        int n2 = SolarisLibc.INSTANCE.getloadavg(dArray, n);
        if (n2 < n) {
            for (int i = Math.max(n2, 0); i < dArray.length; ++i) {
                dArray[i] = -1.0;
            }
        }
        return dArray;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryProcessorCpuLoadTicks2(this.getLogicalProcessorCount());
        }
        long[][] lArray = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int n = -1;
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            for (LibKstat.Kstat kstat : kstatChain.lookupAll("cpu", -1, "sys")) {
                if (++n >= lArray.length) {
                    break;
                }
                if (!kstatChain.read(kstat)) continue;
                lArray[n][CentralProcessor.TickType.IDLE.getIndex()] = KstatUtil.dataLookupLong(kstat, "cpu_ticks_idle");
                lArray[n][CentralProcessor.TickType.SYSTEM.getIndex()] = KstatUtil.dataLookupLong(kstat, "cpu_ticks_kernel");
                lArray[n][CentralProcessor.TickType.USER.getIndex()] = KstatUtil.dataLookupLong(kstat, "cpu_ticks_user");
            }
        }
        return lArray;
    }

    private static long[][] queryProcessorCpuLoadTicks2(int n) {
        long[][] lArray = new long[n][CentralProcessor.TickType.values().length];
        List<Object[]> list = KstatUtil.queryKstat2List(KSTAT_SYSTEM_CPU, SYS, "cpu_ticks_idle", "cpu_ticks_kernel", "cpu_ticks_user");
        int n2 = -1;
        for (Object[] objectArray : list) {
            if (++n2 >= lArray.length) break;
            lArray[n2][CentralProcessor.TickType.IDLE.getIndex()] = objectArray[0] == null ? 0L : (Long)objectArray[0];
            lArray[n2][CentralProcessor.TickType.SYSTEM.getIndex()] = objectArray[1] == null ? 0L : (Long)objectArray[1];
            lArray[n2][CentralProcessor.TickType.USER.getIndex()] = objectArray[2] == null ? 0L : (Long)objectArray[2];
        }
        return lArray;
    }

    private static String getProcessorID(String string, String string2, String string3) {
        List<String> list = ExecutingCommand.runNative("isainfo -v");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : list) {
            if (string4.startsWith("32-bit")) break;
            if (string4.startsWith("64-bit")) continue;
            stringBuilder.append(' ').append(string4.trim());
        }
        return SolarisCentralProcessor.createProcessorID(string, string2, string3, ParseUtil.whitespaces.split(stringBuilder.toString().toLowerCase(Locale.ROOT)));
    }

    @Override
    public long queryContextSwitches() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryContextSwitches2();
        }
        long l = 0L;
        List<String> list = ExecutingCommand.runNative("kstat -p cpu_stat:::/pswitch\\\\|inv_swtch/");
        for (String string : list) {
            l += ParseUtil.parseLastLong(string, 0L);
        }
        return l;
    }

    private static long queryContextSwitches2() {
        long l = 0L;
        List<Object[]> list = KstatUtil.queryKstat2List(KSTAT_SYSTEM_CPU, SYS, "pswitch", "inv_swtch");
        for (Object[] objectArray : list) {
            l += objectArray[0] == null ? 0L : (Long)objectArray[0];
            l += objectArray[1] == null ? 0L : (Long)objectArray[1];
        }
        return l;
    }

    @Override
    public long queryInterrupts() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SolarisCentralProcessor.queryInterrupts2();
        }
        long l = 0L;
        List<String> list = ExecutingCommand.runNative("kstat -p cpu_stat:::/intr/");
        for (String string : list) {
            l += ParseUtil.parseLastLong(string, 0L);
        }
        return l;
    }

    private static long queryInterrupts2() {
        long l = 0L;
        List<Object[]> list = KstatUtil.queryKstat2List(KSTAT_SYSTEM_CPU, SYS, "intr");
        for (Object[] objectArray : list) {
            l += objectArray[0] == null ? 0L : (Long)objectArray[0];
        }
        return l;
    }
}

