/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ApplicationInfo {
    private final String name;
    private final String version;
    private final String vendor;
    private final long timestamp;
    private final Map<String, String> additionalInfo;

    public ApplicationInfo(String string, String string2, String string3, long l, Map<String, String> map) {
        this.name = string;
        this.version = string2;
        this.vendor = string3;
        this.timestamp = l;
        this.additionalInfo = map != null ? new LinkedHashMap<String, String>(map) : Collections.emptyMap();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public String toString() {
        return "AppInfo{name=" + this.name + ", version=" + this.version + ", vendor=" + this.vendor + ", timestamp=" + this.timestamp + ", additionalInfo=" + this.additionalInfo + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ApplicationInfo)) {
            return false;
        }
        ApplicationInfo applicationInfo = (ApplicationInfo)object;
        return this.timestamp == applicationInfo.timestamp && Objects.equals(this.name, applicationInfo.name) && Objects.equals(this.version, applicationInfo.version) && Objects.equals(this.vendor, applicationInfo.vendor) && Objects.equals(this.additionalInfo, applicationInfo.additionalInfo);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.vendor, this.timestamp, this.additionalInfo);
    }
}

