/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public class RealmsTextureManager {
    private static final Map<String, RealmsTexture> TEXTURES = Maps.newHashMap();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation TEMPLATE_ICON_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/presets/isles.png");

    public static ResourceLocation worldTemplate(String p_270945_, @Nullable String p_270612_) {
        if (p_270612_ == null) {
            return TEMPLATE_ICON_LOCATION;
        }
        return RealmsTextureManager.getTexture(p_270945_, p_270612_);
    }

    private static ResourceLocation getTexture(String p_90197_, String p_90198_) {
        RealmsTexture $$2 = TEXTURES.get(p_90197_);
        if ($$2 != null && $$2.image().equals(p_90198_)) {
            return $$2.textureId;
        }
        NativeImage $$3 = RealmsTextureManager.loadImage(p_90198_);
        if ($$3 == null) {
            ResourceLocation $$4 = MissingTextureAtlasSprite.getLocation();
            TEXTURES.put(p_90197_, new RealmsTexture(p_90198_, $$4));
            return $$4;
        }
        ResourceLocation $$5 = ResourceLocation.fromNamespaceAndPath("realms", "dynamic/" + p_90197_);
        Minecraft.getInstance().getTextureManager().register($$5, (AbstractTexture)new DynamicTexture($$3));
        TEXTURES.put(p_90197_, new RealmsTexture(p_90198_, $$5));
        return $$5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static NativeImage loadImage(String p_270725_) {
        byte[] $$1 = Base64.getDecoder().decode(p_270725_);
        ByteBuffer $$2 = MemoryUtil.memAlloc((int)$$1.length);
        try {
            NativeImage nativeImage = NativeImage.read($$2.put($$1).flip());
            return nativeImage;
        }
        catch (IOException $$3) {
            LOGGER.warn("Failed to load world image: {}", (Object)p_270725_, (Object)$$3);
        }
        finally {
            MemoryUtil.memFree((Buffer)$$2);
        }
        return null;
    }

    public record RealmsTexture(String image, ResourceLocation textureId) {
    }
}

