/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.MapDecorationTextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Matrix4f;

public class MapRenderer
implements AutoCloseable {
    private static final int WIDTH = 128;
    private static final int HEIGHT = 128;
    final TextureManager textureManager;
    final MapDecorationTextureManager decorationTextures;
    private final Int2ObjectMap<MapInstance> maps = new Int2ObjectOpenHashMap();

    public MapRenderer(TextureManager p_93259_, MapDecorationTextureManager p_335870_) {
        this.textureManager = p_93259_;
        this.decorationTextures = p_335870_;
    }

    public void update(MapId p_323687_, MapItemSavedData p_168767_) {
        this.getOrCreateMapInstance(p_323687_, p_168767_).forceUpload();
    }

    public void render(PoseStack p_168772_, MultiBufferSource p_168773_, MapId p_324127_, MapItemSavedData p_168775_, boolean p_168776_, int p_168774_) {
        this.getOrCreateMapInstance(p_324127_, p_168775_).draw(p_168772_, p_168773_, p_168776_, p_168774_);
    }

    private MapInstance getOrCreateMapInstance(MapId p_323495_, MapItemSavedData p_168780_) {
        return (MapInstance)this.maps.compute(p_323495_.id(), (p_182563_, p_182564_) -> {
            if (p_182564_ == null) {
                return new MapInstance((int)p_182563_, p_168780_);
            }
            p_182564_.replaceMapData(p_168780_);
            return p_182564_;
        });
    }

    public void resetData() {
        for (MapInstance $$0 : this.maps.values()) {
            $$0.close();
        }
        this.maps.clear();
    }

    @Override
    public void close() {
        this.resetData();
    }

    class MapInstance
    implements AutoCloseable {
        private MapItemSavedData data;
        private final DynamicTexture texture;
        private final RenderType renderType;
        private boolean requiresUpload = true;

        MapInstance(int p_168783_, MapItemSavedData p_168784_) {
            this.data = p_168784_;
            this.texture = new DynamicTexture(128, 128, true);
            ResourceLocation $$2 = MapRenderer.this.textureManager.register("map/" + p_168783_, this.texture);
            this.renderType = RenderType.text($$2);
        }

        void replaceMapData(MapItemSavedData p_182568_) {
            boolean $$1 = this.data != p_182568_;
            this.data = p_182568_;
            this.requiresUpload |= $$1;
        }

        public void forceUpload() {
            this.requiresUpload = true;
        }

        private void updateTexture() {
            for (int $$0 = 0; $$0 < 128; ++$$0) {
                for (int $$1 = 0; $$1 < 128; ++$$1) {
                    int $$2 = $$1 + $$0 * 128;
                    this.texture.getPixels().setPixelRGBA($$1, $$0, MapColor.getColorFromPackedId(this.data.colors[$$2]));
                }
            }
            this.texture.upload();
        }

        void draw(PoseStack p_93292_, MultiBufferSource p_93293_, boolean p_93294_, int p_93295_) {
            if (this.requiresUpload) {
                this.updateTexture();
                this.requiresUpload = false;
            }
            boolean $$4 = false;
            boolean $$5 = false;
            float $$6 = 0.0f;
            Matrix4f $$7 = p_93292_.last().pose();
            VertexConsumer $$8 = p_93293_.getBuffer(this.renderType);
            $$8.addVertex($$7, 0.0f, 128.0f, -0.01f).setColor(-1).setUv(0.0f, 1.0f).setLight(p_93295_);
            $$8.addVertex($$7, 128.0f, 128.0f, -0.01f).setColor(-1).setUv(1.0f, 1.0f).setLight(p_93295_);
            $$8.addVertex($$7, 128.0f, 0.0f, -0.01f).setColor(-1).setUv(1.0f, 0.0f).setLight(p_93295_);
            $$8.addVertex($$7, 0.0f, 0.0f, -0.01f).setColor(-1).setUv(0.0f, 0.0f).setLight(p_93295_);
            int $$9 = 0;
            for (MapDecoration $$10 : this.data.getDecorations()) {
                if (p_93294_ && !$$10.renderOnFrame()) continue;
                p_93292_.pushPose();
                p_93292_.translate(0.0f + (float)$$10.x() / 2.0f + 64.0f, 0.0f + (float)$$10.y() / 2.0f + 64.0f, -0.02f);
                p_93292_.mulPose(Axis.ZP.rotationDegrees((float)($$10.rot() * 360) / 16.0f));
                p_93292_.scale(4.0f, 4.0f, 3.0f);
                p_93292_.translate(-0.125f, 0.125f, 0.0f);
                Matrix4f $$11 = p_93292_.last().pose();
                float $$12 = -0.001f;
                TextureAtlasSprite $$13 = MapRenderer.this.decorationTextures.get($$10);
                float $$14 = $$13.getU0();
                float $$15 = $$13.getV0();
                float $$16 = $$13.getU1();
                float $$17 = $$13.getV1();
                VertexConsumer $$18 = p_93293_.getBuffer(RenderType.text($$13.atlasLocation()));
                $$18.addVertex($$11, -1.0f, 1.0f, (float)$$9 * -0.001f).setColor(-1).setUv($$14, $$15).setLight(p_93295_);
                $$18.addVertex($$11, 1.0f, 1.0f, (float)$$9 * -0.001f).setColor(-1).setUv($$16, $$15).setLight(p_93295_);
                $$18.addVertex($$11, 1.0f, -1.0f, (float)$$9 * -0.001f).setColor(-1).setUv($$16, $$17).setLight(p_93295_);
                $$18.addVertex($$11, -1.0f, -1.0f, (float)$$9 * -0.001f).setColor(-1).setUv($$14, $$17).setLight(p_93295_);
                p_93292_.popPose();
                if ($$10.name().isPresent()) {
                    Font $$19 = Minecraft.getInstance().font;
                    Component $$20 = $$10.name().get();
                    float $$21 = $$19.width($$20);
                    float f = 25.0f / $$21;
                    Objects.requireNonNull($$19);
                    float $$22 = Mth.clamp(f, 0.0f, 6.0f / 9.0f);
                    p_93292_.pushPose();
                    p_93292_.translate(0.0f + (float)$$10.x() / 2.0f + 64.0f - $$21 * $$22 / 2.0f, 0.0f + (float)$$10.y() / 2.0f + 64.0f + 4.0f, -0.025f);
                    p_93292_.scale($$22, $$22, 1.0f);
                    p_93292_.translate(0.0f, 0.0f, -0.1f);
                    $$19.drawInBatch($$20, 0.0f, 0.0f, -1, false, p_93292_.last().pose(), p_93293_, Font.DisplayMode.NORMAL, Integer.MIN_VALUE, p_93295_);
                    p_93292_.popPose();
                }
                ++$$9;
            }
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

