/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;

public class EditBox
extends AbstractWidget
implements Renderable {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("widget/text_field"), ResourceLocation.withDefaultNamespace("widget/text_field_highlighted"));
    public static final int BACKWARDS = -1;
    public static final int FORWARDS = 1;
    private static final int CURSOR_INSERT_WIDTH = 1;
    private static final int CURSOR_INSERT_COLOR = -3092272;
    private static final String CURSOR_APPEND_CHARACTER = "_";
    public static final int DEFAULT_TEXT_COLOR = 0xE0E0E0;
    private static final int CURSOR_BLINK_INTERVAL_MS = 300;
    private final Font font;
    private String value = "";
    private int maxLength = 32;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (p_94147_, p_94148_) -> FormattedCharSequence.forward(p_94147_, Style.EMPTY);
    @Nullable
    private Component hint;
    private long focusedTime = Util.getMillis();

    public EditBox(Font p_294485_, int p_294264_, int p_295938_, Component p_294624_) {
        this(p_294485_, 0, 0, p_294264_, p_295938_, p_294624_);
    }

    public EditBox(Font p_94114_, int p_94115_, int p_94116_, int p_94117_, int p_94118_, Component p_94119_) {
        this(p_94114_, p_94115_, p_94116_, p_94117_, p_94118_, null, p_94119_);
    }

    public EditBox(Font p_94106_, int p_94107_, int p_94108_, int p_94109_, int p_94110_, @Nullable EditBox p_94111_, Component p_94112_) {
        super(p_94107_, p_94108_, p_94109_, p_94110_, p_94112_);
        this.font = p_94106_;
        if (p_94111_ != null) {
            this.setValue(p_94111_.getValue());
        }
    }

    public void setResponder(Consumer<String> p_94152_) {
        this.responder = p_94152_;
    }

    public void setFormatter(BiFunction<String, Integer, FormattedCharSequence> p_94150_) {
        this.formatter = p_94150_;
    }

    @Override
    protected MutableComponent createNarrationMessage() {
        Component $$0 = this.getMessage();
        return Component.translatable("gui.narrate.editBox", $$0, this.value);
    }

    public void setValue(String p_94145_) {
        if (!this.filter.test(p_94145_)) {
            return;
        }
        this.value = p_94145_.length() > this.maxLength ? p_94145_.substring(0, this.maxLength) : p_94145_;
        this.moveCursorToEnd(false);
        this.setHighlightPos(this.cursorPos);
        this.onValueChange(p_94145_);
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int $$0 = Math.min(this.cursorPos, this.highlightPos);
        int $$1 = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring($$0, $$1);
    }

    public void setFilter(Predicate<String> p_94154_) {
        this.filter = p_94154_;
    }

    public void insertText(String p_94165_) {
        String $$6;
        int $$1 = Math.min(this.cursorPos, this.highlightPos);
        int $$2 = Math.max(this.cursorPos, this.highlightPos);
        int $$3 = this.maxLength - this.value.length() - ($$1 - $$2);
        if ($$3 <= 0) {
            return;
        }
        String $$4 = StringUtil.filterText(p_94165_);
        int $$5 = $$4.length();
        if ($$3 < $$5) {
            if (Character.isHighSurrogate($$4.charAt($$3 - 1))) {
                --$$3;
            }
            $$4 = $$4.substring(0, $$3);
            $$5 = $$3;
        }
        if (!this.filter.test($$6 = new StringBuilder(this.value).replace($$1, $$2, $$4).toString())) {
            return;
        }
        this.value = $$6;
        this.setCursorPosition($$1 + $$5);
        this.setHighlightPos(this.cursorPos);
        this.onValueChange(this.value);
    }

    private void onValueChange(String p_94175_) {
        if (this.responder != null) {
            this.responder.accept(p_94175_);
        }
    }

    private void deleteText(int p_94218_) {
        if (Screen.hasControlDown()) {
            this.deleteWords(p_94218_);
        } else {
            this.deleteChars(p_94218_);
        }
    }

    public void deleteWords(int p_94177_) {
        if (this.value.isEmpty()) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        this.deleteCharsToPos(this.getWordPosition(p_94177_));
    }

    public void deleteChars(int p_94181_) {
        this.deleteCharsToPos(this.getCursorPos(p_94181_));
    }

    public void deleteCharsToPos(int p_314620_) {
        int $$2;
        if (this.value.isEmpty()) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        int $$1 = Math.min(p_314620_, this.cursorPos);
        if ($$1 == ($$2 = Math.max(p_314620_, this.cursorPos))) {
            return;
        }
        String $$3 = new StringBuilder(this.value).delete($$1, $$2).toString();
        if (!this.filter.test($$3)) {
            return;
        }
        this.value = $$3;
        this.moveCursorTo($$1, false);
    }

    public int getWordPosition(int p_94185_) {
        return this.getWordPosition(p_94185_, this.getCursorPosition());
    }

    private int getWordPosition(int p_94129_, int p_94130_) {
        return this.getWordPosition(p_94129_, p_94130_, true);
    }

    private int getWordPosition(int p_94141_, int p_94142_, boolean p_94143_) {
        int $$3 = p_94142_;
        boolean $$4 = p_94141_ < 0;
        int $$5 = Math.abs(p_94141_);
        for (int $$6 = 0; $$6 < $$5; ++$$6) {
            if ($$4) {
                while (p_94143_ && $$3 > 0 && this.value.charAt($$3 - 1) == ' ') {
                    --$$3;
                }
                while ($$3 > 0 && this.value.charAt($$3 - 1) != ' ') {
                    --$$3;
                }
                continue;
            }
            int $$7 = this.value.length();
            if (($$3 = this.value.indexOf(32, $$3)) == -1) {
                $$3 = $$7;
                continue;
            }
            while (p_94143_ && $$3 < $$7 && this.value.charAt($$3) == ' ') {
                ++$$3;
            }
        }
        return $$3;
    }

    public void moveCursor(int p_94189_, boolean p_295737_) {
        this.moveCursorTo(this.getCursorPos(p_94189_), p_295737_);
    }

    private int getCursorPos(int p_94221_) {
        return Util.offsetByCodepoints(this.value, this.cursorPos, p_94221_);
    }

    public void moveCursorTo(int p_94193_, boolean p_294422_) {
        this.setCursorPosition(p_94193_);
        if (!p_294422_) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void setCursorPosition(int p_94197_) {
        this.cursorPos = Mth.clamp(p_94197_, 0, this.value.length());
        this.scrollTo(this.cursorPos);
    }

    public void moveCursorToStart(boolean p_295890_) {
        this.moveCursorTo(0, p_295890_);
    }

    public void moveCursorToEnd(boolean p_296224_) {
        this.moveCursorTo(this.value.length(), p_296224_);
    }

    @Override
    public boolean keyPressed(int p_94132_, int p_94133_, int p_94134_) {
        if (!this.isActive() || !this.isFocused()) {
            return false;
        }
        switch (p_94132_) {
            case 263: {
                if (Screen.hasControlDown()) {
                    this.moveCursorTo(this.getWordPosition(-1), Screen.hasShiftDown());
                } else {
                    this.moveCursor(-1, Screen.hasShiftDown());
                }
                return true;
            }
            case 262: {
                if (Screen.hasControlDown()) {
                    this.moveCursorTo(this.getWordPosition(1), Screen.hasShiftDown());
                } else {
                    this.moveCursor(1, Screen.hasShiftDown());
                }
                return true;
            }
            case 259: {
                if (this.isEditable) {
                    this.deleteText(-1);
                }
                return true;
            }
            case 261: {
                if (this.isEditable) {
                    this.deleteText(1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart(Screen.hasShiftDown());
                return true;
            }
            case 269: {
                this.moveCursorToEnd(Screen.hasShiftDown());
                return true;
            }
        }
        if (Screen.isSelectAll(p_94132_)) {
            this.moveCursorToEnd(false);
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.isCopy(p_94132_)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
            return true;
        }
        if (Screen.isPaste(p_94132_)) {
            if (this.isEditable()) {
                this.insertText(Minecraft.getInstance().keyboardHandler.getClipboard());
            }
            return true;
        }
        if (Screen.isCut(p_94132_)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
            if (this.isEditable()) {
                this.insertText("");
            }
            return true;
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.isActive() && this.isFocused() && this.isEditable();
    }

    @Override
    public boolean charTyped(char p_94122_, int p_94123_) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (StringUtil.isAllowedChatCharacter(p_94122_)) {
            if (this.isEditable) {
                this.insertText(Character.toString(p_94122_));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onClick(double p_279417_, double p_279437_) {
        int $$2 = Mth.floor(p_279417_) - this.getX();
        if (this.bordered) {
            $$2 -= 4;
        }
        String $$3 = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
        this.moveCursorTo(this.font.plainSubstrByWidth($$3, $$2).length() + this.displayPos, Screen.hasShiftDown());
    }

    @Override
    public void playDownSound(SoundManager p_279245_) {
    }

    @Override
    public void renderWidget(GuiGraphics p_283252_, int p_281594_, int p_282100_, float p_283101_) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isBordered()) {
            ResourceLocation $$4 = SPRITES.get(this.isActive(), this.isFocused());
            p_283252_.blitSprite($$4, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        int $$5 = this.isEditable ? this.textColor : this.textColorUneditable;
        int $$6 = this.cursorPos - this.displayPos;
        String $$7 = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
        boolean $$8 = $$6 >= 0 && $$6 <= $$7.length();
        boolean $$9 = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L && $$8;
        int $$10 = this.bordered ? this.getX() + 4 : this.getX();
        int $$11 = this.bordered ? this.getY() + (this.height - 8) / 2 : this.getY();
        int $$12 = $$10;
        int $$13 = Mth.clamp(this.highlightPos - this.displayPos, 0, $$7.length());
        if (!$$7.isEmpty()) {
            String $$14 = $$8 ? $$7.substring(0, $$6) : $$7;
            $$12 = p_283252_.drawString(this.font, this.formatter.apply($$14, this.displayPos), $$12, $$11, $$5);
        }
        boolean $$15 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
        int $$16 = $$12;
        if (!$$8) {
            $$16 = $$6 > 0 ? $$10 + this.width : $$10;
        } else if ($$15) {
            --$$16;
            --$$12;
        }
        if (!$$7.isEmpty() && $$8 && $$6 < $$7.length()) {
            p_283252_.drawString(this.font, this.formatter.apply($$7.substring($$6), this.cursorPos), $$12, $$11, $$5);
        }
        if (this.hint != null && $$7.isEmpty() && !this.isFocused()) {
            p_283252_.drawString(this.font, this.hint, $$12, $$11, $$5);
        }
        if (!$$15 && this.suggestion != null) {
            p_283252_.drawString(this.font, this.suggestion, $$16 - 1, $$11, -8355712);
        }
        if ($$9) {
            if ($$15) {
                p_283252_.fill(RenderType.guiOverlay(), $$16, $$11 - 1, $$16 + 1, $$11 + 1 + this.font.lineHeight, -3092272);
            } else {
                p_283252_.drawString(this.font, CURSOR_APPEND_CHARACTER, $$16, $$11, $$5);
            }
        }
        if ($$13 != $$6) {
            int $$17 = $$10 + this.font.width($$7.substring(0, $$13));
            this.renderHighlight(p_283252_, $$16, $$11 - 1, $$17 - 1, $$11 + 1 + this.font.lineHeight);
        }
    }

    private void renderHighlight(GuiGraphics p_281400_, int p_265338_, int p_265693_, int p_265618_, int p_265584_) {
        if (p_265338_ < p_265618_) {
            int $$5 = p_265338_;
            p_265338_ = p_265618_;
            p_265618_ = $$5;
        }
        if (p_265693_ < p_265584_) {
            int $$6 = p_265693_;
            p_265693_ = p_265584_;
            p_265584_ = $$6;
        }
        if (p_265618_ > this.getX() + this.width) {
            p_265618_ = this.getX() + this.width;
        }
        if (p_265338_ > this.getX() + this.width) {
            p_265338_ = this.getX() + this.width;
        }
        p_281400_.fill(RenderType.guiTextHighlight(), p_265338_, p_265693_, p_265618_, p_265584_, -16776961);
    }

    public void setMaxLength(int p_94200_) {
        this.maxLength = p_94200_;
        if (this.value.length() > p_94200_) {
            this.value = this.value.substring(0, p_94200_);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean p_94183_) {
        this.bordered = p_94183_;
    }

    public void setTextColor(int p_94203_) {
        this.textColor = p_94203_;
    }

    public void setTextColorUneditable(int p_94206_) {
        this.textColorUneditable = p_94206_;
    }

    @Override
    public void setFocused(boolean p_265520_) {
        if (!this.canLoseFocus && !p_265520_) {
            return;
        }
        super.setFocused(p_265520_);
        if (p_265520_) {
            this.focusedTime = Util.getMillis();
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean p_94187_) {
        this.isEditable = p_94187_;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.width - 8 : this.width;
    }

    public void setHighlightPos(int p_94209_) {
        this.highlightPos = Mth.clamp(p_94209_, 0, this.value.length());
        this.scrollTo(this.highlightPos);
    }

    private void scrollTo(int p_296429_) {
        if (this.font == null) {
            return;
        }
        this.displayPos = Math.min(this.displayPos, this.value.length());
        int $$1 = this.getInnerWidth();
        String $$2 = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), $$1);
        int $$3 = $$2.length() + this.displayPos;
        if (p_296429_ == this.displayPos) {
            this.displayPos -= this.font.plainSubstrByWidth(this.value, $$1, true).length();
        }
        if (p_296429_ > $$3) {
            this.displayPos += p_296429_ - $$3;
        } else if (p_296429_ <= this.displayPos) {
            this.displayPos -= this.displayPos - p_296429_;
        }
        this.displayPos = Mth.clamp(this.displayPos, 0, this.value.length());
    }

    public void setCanLoseFocus(boolean p_94191_) {
        this.canLoseFocus = p_94191_;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean p_94195_) {
        this.visible = p_94195_;
    }

    public void setSuggestion(@Nullable String p_94168_) {
        this.suggestion = p_94168_;
    }

    public int getScreenX(int p_94212_) {
        if (p_94212_ > this.value.length()) {
            return this.getX();
        }
        return this.getX() + this.font.width(this.value.substring(0, p_94212_));
    }

    @Override
    public void updateWidgetNarration(NarrationElementOutput p_259237_) {
        p_259237_.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }

    public void setHint(Component p_259584_) {
        this.hint = p_259584_;
    }
}

