/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;

public class PiglinModel<T extends Mob>
extends PlayerModel<T> {
    public final ModelPart rightEar;
    private final ModelPart leftEar;
    private final PartPose bodyDefault;
    private final PartPose headDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;

    public PiglinModel(ModelPart p_170810_) {
        super(p_170810_, false);
        this.rightEar = this.head.getChild("right_ear");
        this.leftEar = this.head.getChild("left_ear");
        this.bodyDefault = this.body.storePose();
        this.headDefault = this.head.storePose();
        this.leftArmDefault = this.leftArm.storePose();
        this.rightArmDefault = this.rightArm.storePose();
    }

    public static MeshDefinition createMesh(CubeDeformation p_170812_) {
        MeshDefinition $$1 = PlayerModel.createMesh(p_170812_, false);
        PartDefinition $$2 = $$1.getRoot();
        $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170812_), PartPose.ZERO);
        PiglinModel.addHead(p_170812_, $$1);
        $$2.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        return $$1;
    }

    public static void addHead(CubeDeformation p_262174_, MeshDefinition p_262011_) {
        PartDefinition $$2 = p_262011_.getRoot();
        PartDefinition $$3 = $$2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, p_262174_).texOffs(31, 1).addBox(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f, p_262174_).texOffs(2, 4).addBox(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, p_262174_).texOffs(2, 0).addBox(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, p_262174_), PartPose.ZERO);
        $$3.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(51, 6).addBox(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, p_262174_), PartPose.offsetAndRotation(4.5f, -6.0f, 0.0f, 0.0f, 0.0f, -0.5235988f));
        $$3.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(39, 6).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, p_262174_), PartPose.offsetAndRotation(-4.5f, -6.0f, 0.0f, 0.0f, 0.0f, 0.5235988f));
    }

    @Override
    public void setupAnim(T p_103366_, float p_103367_, float p_103368_, float p_103369_, float p_103370_, float p_103371_) {
        this.body.loadPose(this.bodyDefault);
        this.head.loadPose(this.headDefault);
        this.leftArm.loadPose(this.leftArmDefault);
        this.rightArm.loadPose(this.rightArmDefault);
        super.setupAnim(p_103366_, p_103367_, p_103368_, p_103369_, p_103370_, p_103371_);
        float $$6 = 0.5235988f;
        float $$7 = p_103369_ * 0.1f + p_103367_ * 0.5f;
        float $$8 = 0.08f + p_103368_ * 0.4f;
        this.leftEar.zRot = -0.5235988f - Mth.cos($$7 * 1.2f) * $$8;
        this.rightEar.zRot = 0.5235988f + Mth.cos($$7) * $$8;
        if (p_103366_ instanceof AbstractPiglin) {
            AbstractPiglin $$9 = (AbstractPiglin)p_103366_;
            PiglinArmPose $$10 = $$9.getArmPose();
            if ($$10 == PiglinArmPose.DANCING) {
                float $$11 = p_103369_ / 60.0f;
                this.rightEar.zRot = 0.5235988f + (float)Math.PI / 180 * Mth.sin($$11 * 30.0f) * 10.0f;
                this.leftEar.zRot = -0.5235988f - (float)Math.PI / 180 * Mth.cos($$11 * 30.0f) * 10.0f;
                this.head.x = Mth.sin($$11 * 10.0f);
                this.head.y = Mth.sin($$11 * 40.0f) + 0.4f;
                this.rightArm.zRot = (float)Math.PI / 180 * (70.0f + Mth.cos($$11 * 40.0f) * 10.0f);
                this.leftArm.zRot = this.rightArm.zRot * -1.0f;
                this.rightArm.y = Mth.sin($$11 * 40.0f) * 0.5f + 1.5f;
                this.leftArm.y = Mth.sin($$11 * 40.0f) * 0.5f + 1.5f;
                this.body.y = Mth.sin($$11 * 40.0f) * 0.35f;
            } else if ($$10 == PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON && this.attackTime == 0.0f) {
                this.holdWeaponHigh(p_103366_);
            } else if ($$10 == PiglinArmPose.CROSSBOW_HOLD) {
                AnimationUtils.animateCrossbowHold(this.rightArm, this.leftArm, this.head, !((Mob)p_103366_).isLeftHanded());
            } else if ($$10 == PiglinArmPose.CROSSBOW_CHARGE) {
                AnimationUtils.animateCrossbowCharge(this.rightArm, this.leftArm, p_103366_, !((Mob)p_103366_).isLeftHanded());
            } else if ($$10 == PiglinArmPose.ADMIRING_ITEM) {
                this.head.xRot = 0.5f;
                this.head.yRot = 0.0f;
                if (((Mob)p_103366_).isLeftHanded()) {
                    this.rightArm.yRot = -0.5f;
                    this.rightArm.xRot = -0.9f;
                } else {
                    this.leftArm.yRot = 0.5f;
                    this.leftArm.xRot = -0.9f;
                }
            }
        } else if (((Entity)p_103366_).getType() == EntityType.ZOMBIFIED_PIGLIN) {
            AnimationUtils.animateZombieArms(this.leftArm, this.rightArm, ((Mob)p_103366_).isAggressive(), this.attackTime, p_103369_);
        }
        this.leftPants.copyFrom(this.leftLeg);
        this.rightPants.copyFrom(this.rightLeg);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        this.jacket.copyFrom(this.body);
        this.hat.copyFrom(this.head);
    }

    @Override
    protected void setupAttackAnimation(T p_103363_, float p_103364_) {
        if (this.attackTime > 0.0f && p_103363_ instanceof Piglin && ((Piglin)p_103363_).getArmPose() == PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON) {
            AnimationUtils.swingWeaponDown(this.rightArm, this.leftArm, p_103363_, this.attackTime, p_103364_);
            return;
        }
        super.setupAttackAnimation(p_103363_, p_103364_);
    }

    private void holdWeaponHigh(T p_103361_) {
        if (((Mob)p_103361_).isLeftHanded()) {
            this.leftArm.xRot = -1.8f;
        } else {
            this.rightArm.xRot = -1.8f;
        }
    }
}

