/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class Variant
implements ModelState {
    private final ResourceLocation modelLocation;
    private final Transformation rotation;
    private final boolean uvLock;
    private final int weight;

    public Variant(ResourceLocation p_111879_, Transformation p_111880_, boolean p_111881_, int p_111882_) {
        this.modelLocation = p_111879_;
        this.rotation = p_111880_;
        this.uvLock = p_111881_;
        this.weight = p_111882_;
    }

    public ResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    @Override
    public Transformation getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isUvLocked() {
        return this.uvLock;
    }

    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return "Variant{modelLocation=" + String.valueOf(this.modelLocation) + ", rotation=" + String.valueOf(this.rotation) + ", uvLock=" + this.uvLock + ", weight=" + this.weight + "}";
    }

    public boolean equals(Object p_111888_) {
        if (this == p_111888_) {
            return true;
        }
        if (p_111888_ instanceof Variant) {
            Variant $$1 = (Variant)p_111888_;
            return this.modelLocation.equals($$1.modelLocation) && Objects.equals(this.rotation, $$1.rotation) && this.uvLock == $$1.uvLock && this.weight == $$1.weight;
        }
        return false;
    }

    public int hashCode() {
        int $$0 = this.modelLocation.hashCode();
        $$0 = 31 * $$0 + this.rotation.hashCode();
        $$0 = 31 * $$0 + Boolean.valueOf(this.uvLock).hashCode();
        $$0 = 31 * $$0 + this.weight;
        return $$0;
    }

    public static class Deserializer
    implements JsonDeserializer<Variant> {
        @VisibleForTesting
        static final boolean DEFAULT_UVLOCK = false;
        @VisibleForTesting
        static final int DEFAULT_WEIGHT = 1;
        @VisibleForTesting
        static final int DEFAULT_X_ROTATION = 0;
        @VisibleForTesting
        static final int DEFAULT_Y_ROTATION = 0;

        public Variant deserialize(JsonElement p_111893_, Type p_111894_, JsonDeserializationContext p_111895_) throws JsonParseException {
            JsonObject $$3 = p_111893_.getAsJsonObject();
            ResourceLocation $$4 = this.getModel($$3);
            BlockModelRotation $$5 = this.getBlockRotation($$3);
            boolean $$6 = this.getUvLock($$3);
            int $$7 = this.getWeight($$3);
            return new Variant($$4, $$5.getRotation(), $$6, $$7);
        }

        private boolean getUvLock(JsonObject p_111903_) {
            return GsonHelper.getAsBoolean(p_111903_, "uvlock", false);
        }

        protected BlockModelRotation getBlockRotation(JsonObject p_111897_) {
            int $$2;
            int $$1 = GsonHelper.getAsInt(p_111897_, "x", 0);
            BlockModelRotation $$3 = BlockModelRotation.by($$1, $$2 = GsonHelper.getAsInt(p_111897_, "y", 0));
            if ($$3 == null) {
                throw new JsonParseException("Invalid BlockModelRotation x: " + $$1 + ", y: " + $$2);
            }
            return $$3;
        }

        protected ResourceLocation getModel(JsonObject p_111899_) {
            return ResourceLocation.parse(GsonHelper.getAsString(p_111899_, "model"));
        }

        protected int getWeight(JsonObject p_111901_) {
            int $$1 = GsonHelper.getAsInt(p_111901_, "weight", 1);
            if ($$1 < 1) {
                throw new JsonParseException("Invalid weight " + $$1 + " found, expected integer >= 1");
            }
            return $$1;
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

