/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class StructureBlockRenderer
implements BlockEntityRenderer<StructureBlockEntity> {
    public StructureBlockRenderer(BlockEntityRendererProvider.Context p_173675_) {
    }

    @Override
    public void render(StructureBlockEntity p_112583_, float p_112584_, PoseStack p_112585_, MultiBufferSource p_112586_, int p_112587_, int p_112588_) {
        double $$33;
        double $$32;
        double $$31;
        double $$30;
        double $$17;
        double $$16;
        if (!Minecraft.getInstance().player.canUseGameMasterBlocks() && !Minecraft.getInstance().player.isSpectator()) {
            return;
        }
        BlockPos $$6 = p_112583_.getStructurePos();
        Vec3i $$7 = p_112583_.getStructureSize();
        if ($$7.getX() < 1 || $$7.getY() < 1 || $$7.getZ() < 1) {
            return;
        }
        if (p_112583_.getMode() != StructureMode.SAVE && p_112583_.getMode() != StructureMode.LOAD) {
            return;
        }
        double $$8 = $$6.getX();
        double $$9 = $$6.getZ();
        double $$10 = $$6.getY();
        double $$11 = $$10 + (double)$$7.getY();
        switch (p_112583_.getMirror()) {
            case LEFT_RIGHT: {
                double $$12 = $$7.getX();
                double $$13 = -$$7.getZ();
                break;
            }
            case FRONT_BACK: {
                double $$14 = -$$7.getX();
                double $$15 = $$7.getZ();
                break;
            }
            default: {
                $$16 = $$7.getX();
                $$17 = $$7.getZ();
            }
        }
        switch (p_112583_.getRotation()) {
            case CLOCKWISE_90: {
                double $$18 = $$17 < 0.0 ? $$8 : $$8 + 1.0;
                double $$19 = $$16 < 0.0 ? $$9 + 1.0 : $$9;
                double $$20 = $$18 - $$17;
                double $$21 = $$19 + $$16;
                break;
            }
            case CLOCKWISE_180: {
                double $$22 = $$16 < 0.0 ? $$8 : $$8 + 1.0;
                double $$23 = $$17 < 0.0 ? $$9 : $$9 + 1.0;
                double $$24 = $$22 - $$16;
                double $$25 = $$23 - $$17;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                double $$26 = $$17 < 0.0 ? $$8 + 1.0 : $$8;
                double $$27 = $$16 < 0.0 ? $$9 : $$9 + 1.0;
                double $$28 = $$26 + $$17;
                double $$29 = $$27 - $$16;
                break;
            }
            default: {
                $$30 = $$16 < 0.0 ? $$8 + 1.0 : $$8;
                $$31 = $$17 < 0.0 ? $$9 + 1.0 : $$9;
                $$32 = $$30 + $$16;
                $$33 = $$31 + $$17;
            }
        }
        float $$34 = 1.0f;
        float $$35 = 0.9f;
        float $$36 = 0.5f;
        if (p_112583_.getMode() == StructureMode.SAVE || p_112583_.getShowBoundingBox()) {
            VertexConsumer $$37 = p_112586_.getBuffer(RenderType.lines());
            LevelRenderer.renderLineBox(p_112585_, $$37, $$30, $$10, $$31, $$32, $$11, $$33, 0.9f, 0.9f, 0.9f, 1.0f, 0.5f, 0.5f, 0.5f);
        }
        if (p_112583_.getMode() == StructureMode.SAVE && p_112583_.getShowAir()) {
            this.renderInvisibleBlocks(p_112583_, p_112586_, p_112585_);
        }
    }

    private void renderInvisibleBlocks(StructureBlockEntity p_173677_, MultiBufferSource p_352319_, PoseStack p_173680_) {
        Level $$3 = p_173677_.getLevel();
        VertexConsumer $$4 = p_352319_.getBuffer(RenderType.lines());
        BlockPos $$5 = p_173677_.getBlockPos();
        BlockPos $$6 = StructureUtils.getStructureOrigin(p_173677_);
        for (BlockPos $$7 : BlockPos.betweenClosed($$6, $$6.offset(p_173677_.getStructureSize()).offset(-1, -1, -1))) {
            boolean $$13;
            BlockState $$8 = $$3.getBlockState($$7);
            boolean $$9 = $$8.isAir();
            boolean $$10 = $$8.is(Blocks.STRUCTURE_VOID);
            boolean $$11 = $$8.is(Blocks.BARRIER);
            boolean $$12 = $$8.is(Blocks.LIGHT);
            boolean bl = $$13 = $$10 || $$11 || $$12;
            if (!$$9 && !$$13) continue;
            float $$14 = $$9 ? 0.05f : 0.0f;
            double $$15 = (float)($$7.getX() - $$5.getX()) + 0.45f - $$14;
            double $$16 = (float)($$7.getY() - $$5.getY()) + 0.45f - $$14;
            double $$17 = (float)($$7.getZ() - $$5.getZ()) + 0.45f - $$14;
            double $$18 = (float)($$7.getX() - $$5.getX()) + 0.55f + $$14;
            double $$19 = (float)($$7.getY() - $$5.getY()) + 0.55f + $$14;
            double $$20 = (float)($$7.getZ() - $$5.getZ()) + 0.55f + $$14;
            if ($$9) {
                LevelRenderer.renderLineBox(p_173680_, $$4, $$15, $$16, $$17, $$18, $$19, $$20, 0.5f, 0.5f, 1.0f, 1.0f, 0.5f, 0.5f, 1.0f);
                continue;
            }
            if ($$10) {
                LevelRenderer.renderLineBox(p_173680_, $$4, $$15, $$16, $$17, $$18, $$19, $$20, 1.0f, 0.75f, 0.75f, 1.0f, 1.0f, 0.75f, 0.75f);
                continue;
            }
            if ($$11) {
                LevelRenderer.renderLineBox(p_173680_, $$4, $$15, $$16, $$17, $$18, $$19, $$20, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f);
                continue;
            }
            if (!$$12) continue;
            LevelRenderer.renderLineBox(p_173680_, $$4, $$15, $$16, $$17, $$18, $$19, $$20, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    private void renderStructureVoids(StructureBlockEntity p_352299_, VertexConsumer p_352113_, PoseStack p_352426_) {
        Level $$3 = p_352299_.getLevel();
        if ($$3 == null) {
            return;
        }
        BlockPos $$4 = p_352299_.getBlockPos();
        BlockPos $$5 = StructureUtils.getStructureOrigin(p_352299_);
        Vec3i $$6 = p_352299_.getStructureSize();
        BitSetDiscreteVoxelShape $$7 = new BitSetDiscreteVoxelShape($$6.getX(), $$6.getY(), $$6.getZ());
        for (BlockPos $$8 : BlockPos.betweenClosed($$5, $$5.offset($$6).offset(-1, -1, -1))) {
            if (!$$3.getBlockState($$8).is(Blocks.STRUCTURE_VOID)) continue;
            ((DiscreteVoxelShape)$$7).fill($$8.getX() - $$5.getX(), $$8.getY() - $$5.getY(), $$8.getZ() - $$5.getZ());
        }
        $$7.forAllFaces((p_352285_, p_352347_, p_352290_, p_352166_) -> {
            float $$8 = 0.48f;
            float $$9 = (float)(p_352347_ + $$5.getX() - $$4.getX()) + 0.5f - 0.48f;
            float $$10 = (float)(p_352290_ + $$5.getY() - $$4.getY()) + 0.5f - 0.48f;
            float $$11 = (float)(p_352166_ + $$5.getZ() - $$4.getZ()) + 0.5f - 0.48f;
            float $$12 = (float)(p_352347_ + $$5.getX() - $$4.getX()) + 0.5f + 0.48f;
            float $$13 = (float)(p_352290_ + $$5.getY() - $$4.getY()) + 0.5f + 0.48f;
            float $$14 = (float)(p_352166_ + $$5.getZ() - $$4.getZ()) + 0.5f + 0.48f;
            LevelRenderer.renderFace(p_352426_, p_352113_, p_352285_, $$9, $$10, $$11, $$12, $$13, $$14, 0.75f, 0.75f, 1.0f, 0.2f);
        });
    }

    @Override
    public boolean shouldRenderOffScreen(StructureBlockEntity p_112581_) {
        return true;
    }

    @Override
    public int getViewDistance() {
        return 96;
    }
}

