/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.PandaModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.PandaHoldsItemLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Panda;

public class PandaRenderer
extends MobRenderer<Panda, PandaModel<Panda>> {
    private static final Map<Panda.Gene, ResourceLocation> TEXTURES = Util.make(Maps.newEnumMap(Panda.Gene.class), p_349904_ -> {
        p_349904_.put(Panda.Gene.NORMAL, ResourceLocation.withDefaultNamespace("textures/entity/panda/panda.png"));
        p_349904_.put(Panda.Gene.LAZY, ResourceLocation.withDefaultNamespace("textures/entity/panda/lazy_panda.png"));
        p_349904_.put(Panda.Gene.WORRIED, ResourceLocation.withDefaultNamespace("textures/entity/panda/worried_panda.png"));
        p_349904_.put(Panda.Gene.PLAYFUL, ResourceLocation.withDefaultNamespace("textures/entity/panda/playful_panda.png"));
        p_349904_.put(Panda.Gene.BROWN, ResourceLocation.withDefaultNamespace("textures/entity/panda/brown_panda.png"));
        p_349904_.put(Panda.Gene.WEAK, ResourceLocation.withDefaultNamespace("textures/entity/panda/weak_panda.png"));
        p_349904_.put(Panda.Gene.AGGRESSIVE, ResourceLocation.withDefaultNamespace("textures/entity/panda/aggressive_panda.png"));
    });

    public PandaRenderer(EntityRendererProvider.Context p_174334_) {
        super(p_174334_, new PandaModel(p_174334_.bakeLayer(ModelLayers.PANDA)), 0.9f);
        this.addLayer(new PandaHoldsItemLayer(this, p_174334_.getItemInHandRenderer()));
    }

    @Override
    public ResourceLocation getTextureLocation(Panda p_115639_) {
        return TEXTURES.getOrDefault(p_115639_.getVariant(), TEXTURES.get(Panda.Gene.NORMAL));
    }

    @Override
    protected void setupRotations(Panda p_115641_, PoseStack p_115642_, float p_115643_, float p_115644_, float p_115645_, float p_320830_) {
        float $$27;
        float $$25;
        super.setupRotations(p_115641_, p_115642_, p_115643_, p_115644_, p_115645_, p_320830_);
        if (p_115641_.rollCounter > 0) {
            float $$9;
            int $$6 = p_115641_.rollCounter;
            int $$7 = $$6 + 1;
            float $$8 = 7.0f;
            float f = $$9 = p_115641_.isBaby() ? 0.3f : 0.8f;
            if ($$6 < 8) {
                float $$10 = (float)(90 * $$6) / 7.0f;
                float $$11 = (float)(90 * $$7) / 7.0f;
                float $$12 = this.getAngle($$10, $$11, $$7, p_115645_, 8.0f);
                p_115642_.translate(0.0f, ($$9 + 0.2f) * ($$12 / 90.0f), 0.0f);
                p_115642_.mulPose(Axis.XP.rotationDegrees(-$$12));
            } else if ($$6 < 16) {
                float $$13 = ((float)$$6 - 8.0f) / 7.0f;
                float $$14 = 90.0f + 90.0f * $$13;
                float $$15 = 90.0f + 90.0f * ((float)$$7 - 8.0f) / 7.0f;
                float $$16 = this.getAngle($$14, $$15, $$7, p_115645_, 16.0f);
                p_115642_.translate(0.0f, $$9 + 0.2f + ($$9 - 0.2f) * ($$16 - 90.0f) / 90.0f, 0.0f);
                p_115642_.mulPose(Axis.XP.rotationDegrees(-$$16));
            } else if ((float)$$6 < 24.0f) {
                float $$17 = ((float)$$6 - 16.0f) / 7.0f;
                float $$18 = 180.0f + 90.0f * $$17;
                float $$19 = 180.0f + 90.0f * ((float)$$7 - 16.0f) / 7.0f;
                float $$20 = this.getAngle($$18, $$19, $$7, p_115645_, 24.0f);
                p_115642_.translate(0.0f, $$9 + $$9 * (270.0f - $$20) / 90.0f, 0.0f);
                p_115642_.mulPose(Axis.XP.rotationDegrees(-$$20));
            } else if ($$6 < 32) {
                float $$21 = ((float)$$6 - 24.0f) / 7.0f;
                float $$22 = 270.0f + 90.0f * $$21;
                float $$23 = 270.0f + 90.0f * ((float)$$7 - 24.0f) / 7.0f;
                float $$24 = this.getAngle($$22, $$23, $$7, p_115645_, 32.0f);
                p_115642_.translate(0.0f, $$9 * ((360.0f - $$24) / 90.0f), 0.0f);
                p_115642_.mulPose(Axis.XP.rotationDegrees(-$$24));
            }
        }
        if (($$25 = p_115641_.getSitAmount(p_115645_)) > 0.0f) {
            p_115642_.translate(0.0f, 0.8f * $$25, 0.0f);
            p_115642_.mulPose(Axis.XP.rotationDegrees(Mth.lerp($$25, p_115641_.getXRot(), p_115641_.getXRot() + 90.0f)));
            p_115642_.translate(0.0f, -1.0f * $$25, 0.0f);
            if (p_115641_.isScared()) {
                float $$26 = (float)(Math.cos((double)p_115641_.tickCount * 1.25) * Math.PI * (double)0.05f);
                p_115642_.mulPose(Axis.YP.rotationDegrees($$26));
                if (p_115641_.isBaby()) {
                    p_115642_.translate(0.0f, 0.8f, 0.55f);
                }
            }
        }
        if (($$27 = p_115641_.getLieOnBackAmount(p_115645_)) > 0.0f) {
            float $$28 = p_115641_.isBaby() ? 0.5f : 1.3f;
            p_115642_.translate(0.0f, $$28 * $$27, 0.0f);
            p_115642_.mulPose(Axis.XP.rotationDegrees(Mth.lerp($$27, p_115641_.getXRot(), p_115641_.getXRot() + 180.0f)));
        }
    }

    private float getAngle(float p_115625_, float p_115626_, int p_115627_, float p_115628_, float p_115629_) {
        if ((float)p_115627_ < p_115629_) {
            return Mth.lerp(p_115628_, p_115625_, p_115626_);
        }
        return p_115625_;
    }
}

