/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.WitherArmorLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.boss.wither.WitherBoss;

public class WitherBossRenderer
extends MobRenderer<WitherBoss, WitherBossModel<WitherBoss>> {
    private static final ResourceLocation WITHER_INVULNERABLE_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation WITHER_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/wither/wither.png");

    public WitherBossRenderer(EntityRendererProvider.Context p_174445_) {
        super(p_174445_, new WitherBossModel(p_174445_.bakeLayer(ModelLayers.WITHER)), 1.0f);
        this.addLayer(new WitherArmorLayer(this, p_174445_.getModelSet()));
    }

    @Override
    protected int getBlockLightLevel(WitherBoss p_116443_, BlockPos p_116444_) {
        return 15;
    }

    @Override
    public ResourceLocation getTextureLocation(WitherBoss p_116437_) {
        int $$1 = p_116437_.getInvulnerableTicks();
        if ($$1 <= 0 || $$1 <= 80 && $$1 / 5 % 2 == 1) {
            return WITHER_LOCATION;
        }
        return WITHER_INVULNERABLE_LOCATION;
    }

    @Override
    protected void scale(WitherBoss p_116439_, PoseStack p_116440_, float p_116441_) {
        float $$3 = 2.0f;
        int $$4 = p_116439_.getInvulnerableTicks();
        if ($$4 > 0) {
            $$3 -= ((float)$$4 - p_116441_) / 220.0f * 0.5f;
        }
        p_116440_.scale($$3, $$3, $$3);
    }
}

