/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class SpriteContents
implements Stitcher.Entry,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation name;
    final int width;
    final int height;
    private final NativeImage originalImage;
    NativeImage[] byMipLevel;
    @Nullable
    private final AnimatedTexture animatedTexture;
    private final ResourceMetadata metadata;

    public SpriteContents(ResourceLocation p_249787_, FrameSize p_251031_, NativeImage p_252131_, ResourceMetadata p_294742_) {
        this.name = p_249787_;
        this.width = p_251031_.width();
        this.height = p_251031_.height();
        this.metadata = p_294742_;
        AnimationMetadataSection $$4 = p_294742_.getSection(AnimationMetadataSection.SERIALIZER).orElse(AnimationMetadataSection.EMPTY);
        this.animatedTexture = this.createAnimatedTexture(p_251031_, p_252131_.getWidth(), p_252131_.getHeight(), $$4);
        this.originalImage = p_252131_;
        this.byMipLevel = new NativeImage[]{this.originalImage};
    }

    public void increaseMipLevel(int p_248864_) {
        try {
            this.byMipLevel = MipmapGenerator.generateMipLevels(this.byMipLevel, p_248864_);
        }
        catch (Throwable $$1) {
            CrashReport $$2 = CrashReport.forThrowable($$1, "Generating mipmaps for frame");
            CrashReportCategory $$3 = $$2.addCategory("Sprite being mipmapped");
            $$3.setDetail("First frame", () -> {
                StringBuilder $$0 = new StringBuilder();
                if ($$0.length() > 0) {
                    $$0.append(", ");
                }
                $$0.append(this.originalImage.getWidth()).append("x").append(this.originalImage.getHeight());
                return $$0.toString();
            });
            CrashReportCategory $$4 = $$2.addCategory("Frame being iterated");
            $$4.setDetail("Sprite name", this.name);
            $$4.setDetail("Sprite size", () -> this.width + " x " + this.height);
            $$4.setDetail("Sprite frames", () -> this.getFrameCount() + " frames");
            $$4.setDetail("Mipmap levels", p_248864_);
            throw new ReportedException($$2);
        }
    }

    private int getFrameCount() {
        return this.animatedTexture != null ? this.animatedTexture.frames.size() : 1;
    }

    @Nullable
    private AnimatedTexture createAnimatedTexture(FrameSize p_250817_, int p_249792_, int p_252353_, AnimationMetadataSection p_250947_) {
        int $$4 = p_249792_ / p_250817_.width();
        int $$5 = p_252353_ / p_250817_.height();
        int $$6 = $$4 * $$5;
        ArrayList<FrameInfo> $$7 = new ArrayList<FrameInfo>();
        p_250947_.forEachFrame((p_251291_, p_251837_) -> $$7.add(new FrameInfo(p_251291_, p_251837_)));
        if ($$7.isEmpty()) {
            for (int $$8 = 0; $$8 < $$6; ++$$8) {
                $$7.add(new FrameInfo($$8, p_250947_.getDefaultFrameTime()));
            }
        } else {
            int $$9 = 0;
            IntOpenHashSet $$10 = new IntOpenHashSet();
            Iterator $$11 = $$7.iterator();
            while ($$11.hasNext()) {
                FrameInfo $$12 = (FrameInfo)$$11.next();
                boolean $$13 = true;
                if ($$12.time <= 0) {
                    LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", new Object[]{this.name, $$9, $$12.time});
                    $$13 = false;
                }
                if ($$12.index < 0 || $$12.index >= $$6) {
                    LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", new Object[]{this.name, $$9, $$12.index});
                    $$13 = false;
                }
                if ($$13) {
                    $$10.add($$12.index);
                } else {
                    $$11.remove();
                }
                ++$$9;
            }
            int[] $$14 = IntStream.range(0, $$6).filter(arg_0 -> SpriteContents.lambda$createAnimatedTexture$4((IntSet)$$10, arg_0)).toArray();
            if ($$14.length > 0) {
                LOGGER.warn("Unused frames in sprite {}: {}", (Object)this.name, (Object)Arrays.toString($$14));
            }
        }
        if ($$7.size() <= 1) {
            return null;
        }
        return new AnimatedTexture((List<FrameInfo>)ImmutableList.copyOf($$7), $$4, p_250947_.isInterpolatedFrames());
    }

    void upload(int p_248895_, int p_250245_, int p_250458_, int p_251337_, NativeImage[] p_248825_) {
        for (int $$5 = 0; $$5 < this.byMipLevel.length; ++$$5) {
            p_248825_[$$5].upload($$5, p_248895_ >> $$5, p_250245_ >> $$5, p_250458_ >> $$5, p_251337_ >> $$5, this.width >> $$5, this.height >> $$5, this.byMipLevel.length > 1, false);
        }
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public ResourceLocation name() {
        return this.name;
    }

    public IntStream getUniqueFrames() {
        return this.animatedTexture != null ? this.animatedTexture.getUniqueFrames() : IntStream.of(1);
    }

    @Nullable
    public SpriteTicker createTicker() {
        return this.animatedTexture != null ? this.animatedTexture.createTicker() : null;
    }

    public ResourceMetadata metadata() {
        return this.metadata;
    }

    @Override
    public void close() {
        for (NativeImage $$0 : this.byMipLevel) {
            $$0.close();
        }
    }

    public String toString() {
        return "SpriteContents{name=" + String.valueOf(this.name) + ", frameCount=" + this.getFrameCount() + ", height=" + this.height + ", width=" + this.width + "}";
    }

    public boolean isTransparent(int p_250374_, int p_250934_, int p_249573_) {
        int $$3 = p_250934_;
        int $$4 = p_249573_;
        if (this.animatedTexture != null) {
            $$3 += this.animatedTexture.getFrameX(p_250374_) * this.width;
            $$4 += this.animatedTexture.getFrameY(p_250374_) * this.height;
        }
        return (this.originalImage.getPixelRGBA($$3, $$4) >> 24 & 0xFF) == 0;
    }

    public void uploadFirstFrame(int p_252315_, int p_248634_) {
        if (this.animatedTexture != null) {
            this.animatedTexture.uploadFirstFrame(p_252315_, p_248634_);
        } else {
            this.upload(p_252315_, p_248634_, 0, 0, this.byMipLevel);
        }
    }

    private static /* synthetic */ boolean lambda$createAnimatedTexture$4(IntSet p_251708_, int p_251185_) {
        return !p_251708_.contains(p_251185_);
    }

    class AnimatedTexture {
        final List<FrameInfo> frames;
        private final int frameRowSize;
        private final boolean interpolateFrames;

        AnimatedTexture(List<FrameInfo> p_250968_, int p_251686_, boolean p_251832_) {
            this.frames = p_250968_;
            this.frameRowSize = p_251686_;
            this.interpolateFrames = p_251832_;
        }

        int getFrameX(int p_249475_) {
            return p_249475_ % this.frameRowSize;
        }

        int getFrameY(int p_251327_) {
            return p_251327_ / this.frameRowSize;
        }

        void uploadFrame(int p_250449_, int p_248877_, int p_249060_) {
            int $$3 = this.getFrameX(p_249060_) * SpriteContents.this.width;
            int $$4 = this.getFrameY(p_249060_) * SpriteContents.this.height;
            SpriteContents.this.upload(p_250449_, p_248877_, $$3, $$4, SpriteContents.this.byMipLevel);
        }

        public SpriteTicker createTicker() {
            return new Ticker(SpriteContents.this, this, this.interpolateFrames ? new InterpolationData() : null);
        }

        public void uploadFirstFrame(int p_251807_, int p_248676_) {
            this.uploadFrame(p_251807_, p_248676_, this.frames.get((int)0).index);
        }

        public IntStream getUniqueFrames() {
            return this.frames.stream().mapToInt(p_249981_ -> p_249981_.index).distinct();
        }
    }

    static class FrameInfo {
        final int index;
        final int time;

        FrameInfo(int p_248909_, int p_250552_) {
            this.index = p_248909_;
            this.time = p_250552_;
        }
    }

    class Ticker
    implements SpriteTicker {
        int frame;
        int subFrame;
        final AnimatedTexture animationInfo;
        @Nullable
        private final InterpolationData interpolationData;

        Ticker(SpriteContents spriteContents, @Nullable AnimatedTexture p_249618_, InterpolationData p_251097_) {
            this.animationInfo = p_249618_;
            this.interpolationData = p_251097_;
        }

        @Override
        public void tickAndUpload(int p_249105_, int p_249676_) {
            ++this.subFrame;
            FrameInfo $$2 = this.animationInfo.frames.get(this.frame);
            if (this.subFrame >= $$2.time) {
                int $$3 = $$2.index;
                this.frame = (this.frame + 1) % this.animationInfo.frames.size();
                this.subFrame = 0;
                int $$4 = this.animationInfo.frames.get((int)this.frame).index;
                if ($$3 != $$4) {
                    this.animationInfo.uploadFrame(p_249105_, p_249676_, $$4);
                }
            } else if (this.interpolationData != null) {
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.interpolationData.uploadInterpolatedFrame(p_249105_, p_249676_, this));
                } else {
                    this.interpolationData.uploadInterpolatedFrame(p_249105_, p_249676_, this);
                }
            }
        }

        @Override
        public void close() {
            if (this.interpolationData != null) {
                this.interpolationData.close();
            }
        }
    }

    final class InterpolationData
    implements AutoCloseable {
        private final NativeImage[] activeFrame;

        InterpolationData() {
            this.activeFrame = new NativeImage[SpriteContents.this.byMipLevel.length];
            for (int $$0 = 0; $$0 < this.activeFrame.length; ++$$0) {
                int $$1 = SpriteContents.this.width >> $$0;
                int $$2 = SpriteContents.this.height >> $$0;
                this.activeFrame[$$0] = new NativeImage($$1, $$2, false);
            }
        }

        void uploadInterpolatedFrame(int p_250513_, int p_251644_, Ticker p_248626_) {
            AnimatedTexture $$3 = p_248626_.animationInfo;
            List<FrameInfo> $$4 = $$3.frames;
            FrameInfo $$5 = $$4.get(p_248626_.frame);
            double $$6 = 1.0 - (double)p_248626_.subFrame / (double)$$5.time;
            int $$7 = $$5.index;
            int $$8 = $$4.get((int)((p_248626_.frame + 1) % $$4.size())).index;
            if ($$7 != $$8) {
                for (int $$9 = 0; $$9 < this.activeFrame.length; ++$$9) {
                    int $$10 = SpriteContents.this.width >> $$9;
                    int $$11 = SpriteContents.this.height >> $$9;
                    for (int $$12 = 0; $$12 < $$11; ++$$12) {
                        for (int $$13 = 0; $$13 < $$10; ++$$13) {
                            int $$14 = this.getPixel($$3, $$7, $$9, $$13, $$12);
                            int $$15 = this.getPixel($$3, $$8, $$9, $$13, $$12);
                            int $$16 = this.mix($$6, $$14 >> 16 & 0xFF, $$15 >> 16 & 0xFF);
                            int $$17 = this.mix($$6, $$14 >> 8 & 0xFF, $$15 >> 8 & 0xFF);
                            int $$18 = this.mix($$6, $$14 & 0xFF, $$15 & 0xFF);
                            this.activeFrame[$$9].setPixelRGBA($$13, $$12, $$14 & 0xFF000000 | $$16 << 16 | $$17 << 8 | $$18);
                        }
                    }
                }
                SpriteContents.this.upload(p_250513_, p_251644_, 0, 0, this.activeFrame);
            }
        }

        private int getPixel(AnimatedTexture p_251976_, int p_250761_, int p_250049_, int p_250004_, int p_251489_) {
            return SpriteContents.this.byMipLevel[p_250049_].getPixelRGBA(p_250004_ + (p_251976_.getFrameX(p_250761_) * SpriteContents.this.width >> p_250049_), p_251489_ + (p_251976_.getFrameY(p_250761_) * SpriteContents.this.height >> p_250049_));
        }

        private int mix(double p_250974_, int p_252151_, int p_249832_) {
            return (int)(p_250974_ * (double)p_252151_ + (1.0 - p_250974_) * (double)p_249832_);
        }

        @Override
        public void close() {
            for (NativeImage $$0 : this.activeFrame) {
                $$0.close();
            }
        }
    }
}

