/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import org.slf4j.Logger;

public class TextureAtlas
extends AbstractTexture
implements Dumpable,
Tickable {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Deprecated
    public static final ResourceLocation LOCATION_BLOCKS = InventoryMenu.BLOCK_ATLAS;
    @Deprecated
    public static final ResourceLocation LOCATION_PARTICLES = ResourceLocation.withDefaultNamespace("textures/atlas/particles.png");
    private List<SpriteContents> sprites = List.of();
    private List<TextureAtlasSprite.Ticker> animatedTextures = List.of();
    private Map<ResourceLocation, TextureAtlasSprite> texturesByName = Map.of();
    @Nullable
    private TextureAtlasSprite missingSprite;
    private final ResourceLocation location;
    private final int maxSupportedTextureSize;
    private int width;
    private int height;
    private int mipLevel;

    public TextureAtlas(ResourceLocation p_118269_) {
        this.location = p_118269_;
        this.maxSupportedTextureSize = RenderSystem.maxSupportedTextureSize();
    }

    @Override
    public void load(ResourceManager p_118282_) {
    }

    public void upload(SpriteLoader.Preparations p_250662_) {
        LOGGER.info("Created: {}x{}x{} {}-atlas", new Object[]{p_250662_.width(), p_250662_.height(), p_250662_.mipLevel(), this.location});
        TextureUtil.prepareImage(this.getId(), p_250662_.mipLevel(), p_250662_.width(), p_250662_.height());
        this.width = p_250662_.width();
        this.height = p_250662_.height();
        this.mipLevel = p_250662_.mipLevel();
        this.clearTextureData();
        this.texturesByName = Map.copyOf(p_250662_.regions());
        this.missingSprite = this.texturesByName.get(MissingTextureAtlasSprite.getLocation());
        if (this.missingSprite == null) {
            throw new IllegalStateException("Atlas '" + String.valueOf(this.location) + "' (" + this.texturesByName.size() + " sprites) has no missing texture sprite");
        }
        ArrayList<SpriteContents> $$1 = new ArrayList<SpriteContents>();
        ArrayList<TextureAtlasSprite.Ticker> $$2 = new ArrayList<TextureAtlasSprite.Ticker>();
        for (TextureAtlasSprite $$3 : p_250662_.regions().values()) {
            $$1.add($$3.contents());
            try {
                $$3.uploadFirstFrame();
            }
            catch (Throwable $$4) {
                CrashReport $$5 = CrashReport.forThrowable($$4, "Stitching texture atlas");
                CrashReportCategory $$6 = $$5.addCategory("Texture being stitched together");
                $$6.setDetail("Atlas path", this.location);
                $$6.setDetail("Sprite", $$3);
                throw new ReportedException($$5);
            }
            TextureAtlasSprite.Ticker $$7 = $$3.createTicker();
            if ($$7 == null) continue;
            $$2.add($$7);
        }
        this.sprites = List.copyOf($$1);
        this.animatedTextures = List.copyOf($$2);
    }

    @Override
    public void dumpContents(ResourceLocation p_276106_, Path p_276127_) throws IOException {
        String $$2 = p_276106_.toDebugFileName();
        TextureUtil.writeAsPNG(p_276127_, $$2, this.getId(), this.mipLevel, this.width, this.height);
        TextureAtlas.dumpSpriteNames(p_276127_, $$2, this.texturesByName);
    }

    private static void dumpSpriteNames(Path p_261769_, String p_262102_, Map<ResourceLocation, TextureAtlasSprite> p_261722_) {
        Path $$3 = p_261769_.resolve(p_262102_ + ".txt");
        try (BufferedWriter $$4 = Files.newBufferedWriter($$3, new OpenOption[0]);){
            for (Map.Entry $$5 : p_261722_.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                TextureAtlasSprite $$6 = (TextureAtlasSprite)$$5.getValue();
                $$4.write(String.format(Locale.ROOT, "%s\tx=%d\ty=%d\tw=%d\th=%d%n", $$5.getKey(), $$6.getX(), $$6.getY(), $$6.contents().width(), $$6.contents().height()));
            }
        }
        catch (IOException $$7) {
            LOGGER.warn("Failed to write file {}", (Object)$$3, (Object)$$7);
        }
    }

    public void cycleAnimationFrames() {
        this.bind();
        for (TextureAtlasSprite.Ticker $$0 : this.animatedTextures) {
            $$0.tickAndUpload();
        }
    }

    @Override
    public void tick() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::cycleAnimationFrames);
        } else {
            this.cycleAnimationFrames();
        }
    }

    public TextureAtlasSprite getSprite(ResourceLocation p_118317_) {
        TextureAtlasSprite $$1 = this.texturesByName.getOrDefault(p_118317_, this.missingSprite);
        if ($$1 == null) {
            throw new IllegalStateException("Tried to lookup sprite, but atlas is not initialized");
        }
        return $$1;
    }

    public void clearTextureData() {
        this.sprites.forEach(SpriteContents::close);
        this.animatedTextures.forEach(TextureAtlasSprite.Ticker::close);
        this.sprites = List.of();
        this.animatedTextures = List.of();
        this.texturesByName = Map.of();
        this.missingSprite = null;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public int maxSupportedTextureSize() {
        return this.maxSupportedTextureSize;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    public void updateFilter(SpriteLoader.Preparations p_251993_) {
        this.setFilter(false, p_251993_.mipLevel() > 0);
    }
}

