/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.context.CommandContext;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.StructureBlockPosFinder;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.gametest.framework.TestFunctionArgument;
import net.minecraft.gametest.framework.TestFunctionFinder;

public class TestFinder<T>
implements StructureBlockPosFinder,
TestFunctionFinder {
    static final TestFunctionFinder NO_FUNCTIONS = Stream::empty;
    static final StructureBlockPosFinder NO_STRUCTURES = Stream::empty;
    private final TestFunctionFinder testFunctionFinder;
    private final StructureBlockPosFinder structureBlockPosFinder;
    private final CommandSourceStack source;
    private final Function<TestFinder<T>, T> contextProvider;

    @Override
    public Stream<BlockPos> findStructureBlockPos() {
        return this.structureBlockPosFinder.findStructureBlockPos();
    }

    TestFinder(CommandSourceStack p_320004_, Function<TestFinder<T>, T> p_320489_, TestFunctionFinder p_320808_, StructureBlockPosFinder p_320448_) {
        this.source = p_320004_;
        this.contextProvider = p_320489_;
        this.testFunctionFinder = p_320808_;
        this.structureBlockPosFinder = p_320448_;
    }

    T get() {
        return this.contextProvider.apply(this);
    }

    public CommandSourceStack source() {
        return this.source;
    }

    @Override
    public Stream<TestFunction> findTestFunctions() {
        return this.testFunctionFinder.findTestFunctions();
    }

    public static class Builder<T> {
        private final Function<TestFinder<T>, T> contextProvider;
        private final UnaryOperator<Supplier<Stream<TestFunction>>> testFunctionFinderWrapper;
        private final UnaryOperator<Supplier<Stream<BlockPos>>> structureBlockPosFinderWrapper;

        public Builder(Function<TestFinder<T>, T> p_320939_) {
            this.contextProvider = p_320939_;
            this.testFunctionFinderWrapper = p_329857_ -> p_329857_;
            this.structureBlockPosFinderWrapper = p_329858_ -> p_329858_;
        }

        private Builder(Function<TestFinder<T>, T> p_331181_, UnaryOperator<Supplier<Stream<TestFunction>>> p_331301_, UnaryOperator<Supplier<Stream<BlockPos>>> p_331612_) {
            this.contextProvider = p_331181_;
            this.testFunctionFinderWrapper = p_331301_;
            this.structureBlockPosFinderWrapper = p_331612_;
        }

        public Builder<T> createMultipleCopies(int p_330482_) {
            return new Builder<T>(this.contextProvider, Builder.createCopies(p_330482_), Builder.createCopies(p_330482_));
        }

        private static <Q> UnaryOperator<Supplier<Stream<Q>>> createCopies(int p_330804_) {
            return p_329860_ -> {
                LinkedList $$2 = new LinkedList();
                List $$3 = ((Stream)p_329860_.get()).toList();
                for (int $$4 = 0; $$4 < p_330804_; ++$$4) {
                    $$2.addAll($$3);
                }
                return $$2::stream;
            };
        }

        private T build(CommandSourceStack p_330622_, TestFunctionFinder p_330437_, StructureBlockPosFinder p_331860_) {
            return new TestFinder<T>(p_330622_, this.contextProvider, ((Supplier)((Supplier)this.testFunctionFinderWrapper.apply(p_330437_::findTestFunctions)))::get, ((Supplier)((Supplier)this.structureBlockPosFinderWrapper.apply(p_331860_::findStructureBlockPos)))::get).get();
        }

        public T radius(CommandContext<CommandSourceStack> p_320307_, int p_320811_) {
            CommandSourceStack $$2 = (CommandSourceStack)p_320307_.getSource();
            BlockPos $$3 = BlockPos.containing($$2.getPosition());
            return this.build($$2, NO_FUNCTIONS, () -> StructureUtils.findStructureBlocks($$3, p_320811_, $$2.getLevel()));
        }

        public T nearest(CommandContext<CommandSourceStack> p_320944_) {
            CommandSourceStack $$1 = (CommandSourceStack)p_320944_.getSource();
            BlockPos $$2 = BlockPos.containing($$1.getPosition());
            return this.build($$1, NO_FUNCTIONS, () -> StructureUtils.findNearestStructureBlock($$2, 15, $$1.getLevel()).stream());
        }

        public T allNearby(CommandContext<CommandSourceStack> p_320216_) {
            CommandSourceStack $$1 = (CommandSourceStack)p_320216_.getSource();
            BlockPos $$2 = BlockPos.containing($$1.getPosition());
            return this.build($$1, NO_FUNCTIONS, () -> StructureUtils.findStructureBlocks($$2, 200, $$1.getLevel()));
        }

        public T lookedAt(CommandContext<CommandSourceStack> p_320178_) {
            CommandSourceStack $$1 = (CommandSourceStack)p_320178_.getSource();
            return this.build($$1, NO_FUNCTIONS, () -> StructureUtils.lookedAtStructureBlockPos(BlockPos.containing($$1.getPosition()), $$1.getPlayer().getCamera(), $$1.getLevel()));
        }

        public T allTests(CommandContext<CommandSourceStack> p_320902_) {
            return this.build((CommandSourceStack)p_320902_.getSource(), () -> GameTestRegistry.getAllTestFunctions().stream().filter(p_329855_ -> !p_329855_.manualOnly()), NO_STRUCTURES);
        }

        public T allTestsInClass(CommandContext<CommandSourceStack> p_320256_, String p_320231_) {
            return this.build((CommandSourceStack)p_320256_.getSource(), () -> GameTestRegistry.getTestFunctionsForClassName(p_320231_).filter(p_329856_ -> !p_329856_.manualOnly()), NO_STRUCTURES);
        }

        public T failedTests(CommandContext<CommandSourceStack> p_320960_, boolean p_320352_) {
            return this.build((CommandSourceStack)p_320960_.getSource(), () -> GameTestRegistry.getLastFailedTests().filter(p_320430_ -> !p_320352_ || p_320430_.required()), NO_STRUCTURES);
        }

        public T byArgument(CommandContext<CommandSourceStack> p_320475_, String p_320707_) {
            return this.build((CommandSourceStack)p_320475_.getSource(), () -> Stream.of(TestFunctionArgument.getTestFunction(p_320475_, p_320707_)), NO_STRUCTURES);
        }

        public T locateByName(CommandContext<CommandSourceStack> p_341208_, String p_341401_) {
            CommandSourceStack $$2 = (CommandSourceStack)p_341208_.getSource();
            BlockPos $$3 = BlockPos.containing($$2.getPosition());
            return this.build($$2, NO_FUNCTIONS, () -> StructureUtils.findStructureByTestFunction($$3, 1024, $$2.getLevel(), p_341401_));
        }

        public T failedTests(CommandContext<CommandSourceStack> p_320220_) {
            return this.failedTests(p_320220_, false);
        }
    }
}

