/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.zip.Deflater;
import net.minecraft.network.VarInt;

public class CompressionEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final byte[] encodeBuf = new byte[8192];
    private final Deflater deflater;
    private int threshold;

    public CompressionEncoder(int p_129448_) {
        this.threshold = p_129448_;
        this.deflater = new Deflater();
    }

    protected void encode(ChannelHandlerContext p_129452_, ByteBuf p_129453_, ByteBuf p_129454_) {
        int $$3 = p_129453_.readableBytes();
        if ($$3 > 0x800000) {
            throw new IllegalArgumentException("Packet too big (is " + $$3 + ", should be less than 8388608)");
        }
        if ($$3 < this.threshold) {
            VarInt.write(p_129454_, 0);
            p_129454_.writeBytes(p_129453_);
        } else {
            byte[] $$4 = new byte[$$3];
            p_129453_.readBytes($$4);
            VarInt.write(p_129454_, $$4.length);
            this.deflater.setInput($$4, 0, $$3);
            this.deflater.finish();
            while (!this.deflater.finished()) {
                int $$5 = this.deflater.deflate(this.encodeBuf);
                p_129454_.writeBytes(this.encodeBuf, 0, $$5);
            }
            this.deflater.reset();
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int p_129450_) {
        this.threshold = p_129450_;
    }

    protected /* synthetic */ void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) throws Exception {
        this.encode(channelHandlerContext, (ByteBuf)object, byteBuf);
    }
}

