/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.protocol.Packet;

public class UnconfiguredPipelineHandler {
    public static <T extends PacketListener> InboundConfigurationTask setupInboundProtocol(ProtocolInfo<T> p_320435_) {
        return UnconfiguredPipelineHandler.setupInboundHandler(new PacketDecoder<T>(p_320435_));
    }

    private static InboundConfigurationTask setupInboundHandler(ChannelInboundHandler p_320340_) {
        return p_320663_ -> {
            p_320663_.pipeline().replace(p_320663_.name(), "decoder", (ChannelHandler)p_320340_);
            p_320663_.channel().config().setAutoRead(true);
        };
    }

    public static <T extends PacketListener> OutboundConfigurationTask setupOutboundProtocol(ProtocolInfo<T> p_320204_) {
        return UnconfiguredPipelineHandler.setupOutboundHandler(new PacketEncoder<T>(p_320204_));
    }

    private static OutboundConfigurationTask setupOutboundHandler(ChannelOutboundHandler p_319887_) {
        return p_320755_ -> p_320755_.pipeline().replace(p_320755_.name(), "encoder", (ChannelHandler)p_319887_);
    }

    @FunctionalInterface
    public static interface InboundConfigurationTask {
        public void run(ChannelHandlerContext var1);

        default public InboundConfigurationTask andThen(InboundConfigurationTask p_320407_) {
            return p_320785_ -> {
                this.run(p_320785_);
                p_320407_.run(p_320785_);
            };
        }
    }

    @FunctionalInterface
    public static interface OutboundConfigurationTask {
        public void run(ChannelHandlerContext var1);

        default public OutboundConfigurationTask andThen(OutboundConfigurationTask p_320148_) {
            return p_320612_ -> {
                this.run(p_320612_);
                p_320148_.run(p_320612_);
            };
        }
    }

    public static class Outbound
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext p_320511_, Object p_319817_, ChannelPromise p_320083_) throws Exception {
            if (p_319817_ instanceof Packet) {
                ReferenceCountUtil.release((Object)p_319817_);
                throw new EncoderException("Pipeline has no outbound protocol configured, can't process packet " + String.valueOf(p_319817_));
            }
            if (p_319817_ instanceof OutboundConfigurationTask) {
                OutboundConfigurationTask $$3 = (OutboundConfigurationTask)p_319817_;
                try {
                    $$3.run(p_320511_);
                }
                finally {
                    ReferenceCountUtil.release((Object)p_319817_);
                }
                p_320083_.setSuccess();
            } else {
                p_320511_.write(p_319817_, p_320083_);
            }
        }
    }

    public static class Inbound
    extends ChannelDuplexHandler {
        public void channelRead(ChannelHandlerContext p_319789_, Object p_320107_) {
            if (p_320107_ instanceof ByteBuf || p_320107_ instanceof Packet) {
                ReferenceCountUtil.release((Object)p_320107_);
                throw new DecoderException("Pipeline has no inbound protocol configured, can't process packet " + String.valueOf(p_320107_));
            }
            p_319789_.fireChannelRead(p_320107_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext p_320891_, Object p_320121_, ChannelPromise p_320677_) throws Exception {
            if (p_320121_ instanceof InboundConfigurationTask) {
                InboundConfigurationTask $$3 = (InboundConfigurationTask)p_320121_;
                try {
                    $$3.run(p_320891_);
                }
                finally {
                    ReferenceCountUtil.release((Object)p_320121_);
                }
                p_320677_.setSuccess();
            } else {
                p_320891_.write(p_320121_, p_320677_);
            }
        }
    }
}

