/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;

public class ServerChunkCache
extends ChunkSource {
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private final DistanceManager distanceManager;
    final ServerLevel level;
    final Thread mainThread;
    final ThreadedLevelLightEngine lightEngine;
    private final MainThreadExecutor mainThreadProcessor;
    public final ChunkMap chunkMap;
    private final DimensionDataStorage dataStorage;
    private long lastInhabitedUpdate;
    private boolean spawnEnemies = true;
    private boolean spawnFriendlies = true;
    private static final int CACHE_SIZE = 4;
    private final long[] lastChunkPos = new long[4];
    private final ChunkStatus[] lastChunkStatus = new ChunkStatus[4];
    private final ChunkAccess[] lastChunk = new ChunkAccess[4];
    @Nullable
    @VisibleForDebug
    private NaturalSpawner.SpawnState lastSpawnState;

    public ServerChunkCache(ServerLevel p_214982_, LevelStorageSource.LevelStorageAccess p_214983_, DataFixer p_214984_, StructureTemplateManager p_214985_, Executor p_214986_, ChunkGenerator p_214987_, int p_214988_, int p_214989_, boolean p_214990_, ChunkProgressListener p_214991_, ChunkStatusUpdateListener p_214992_, Supplier<DimensionDataStorage> p_214993_) {
        this.level = p_214982_;
        this.mainThreadProcessor = new MainThreadExecutor(p_214982_);
        this.mainThread = Thread.currentThread();
        File $$12 = p_214983_.getDimensionPath(p_214982_.dimension()).resolve("data").toFile();
        $$12.mkdirs();
        this.dataStorage = new DimensionDataStorage($$12, p_214984_, p_214982_.registryAccess());
        this.chunkMap = new ChunkMap(p_214982_, p_214983_, p_214984_, p_214985_, p_214986_, this.mainThreadProcessor, this, p_214987_, p_214991_, p_214992_, p_214993_, p_214988_, p_214990_);
        this.lightEngine = this.chunkMap.getLightEngine();
        this.distanceManager = this.chunkMap.getDistanceManager();
        this.distanceManager.updateSimulationDistance(p_214989_);
        this.clearCache();
    }

    @Override
    public ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    private ChunkHolder getVisibleChunkIfPresent(long p_8365_) {
        return this.chunkMap.getVisibleChunkIfPresent(p_8365_);
    }

    public int getTickingGenerated() {
        return this.chunkMap.getTickingGenerated();
    }

    private void storeInCache(long p_8367_, @Nullable ChunkAccess p_8368_, ChunkStatus p_331839_) {
        for (int $$3 = 3; $$3 > 0; --$$3) {
            this.lastChunkPos[$$3] = this.lastChunkPos[$$3 - 1];
            this.lastChunkStatus[$$3] = this.lastChunkStatus[$$3 - 1];
            this.lastChunk[$$3] = this.lastChunk[$$3 - 1];
        }
        this.lastChunkPos[0] = p_8367_;
        this.lastChunkStatus[0] = p_331839_;
        this.lastChunk[0] = p_8368_;
    }

    @Override
    @Nullable
    public ChunkAccess getChunk(int p_8360_, int p_8361_, ChunkStatus p_330876_, boolean p_8363_) {
        if (Thread.currentThread() != this.mainThread) {
            return CompletableFuture.supplyAsync(() -> this.getChunk(p_8360_, p_8361_, p_330876_, p_8363_), this.mainThreadProcessor).join();
        }
        ProfilerFiller $$4 = this.level.getProfiler();
        $$4.incrementCounter("getChunk");
        long $$5 = ChunkPos.asLong(p_8360_, p_8361_);
        for (int $$6 = 0; $$6 < 4; ++$$6) {
            ChunkAccess $$7;
            if ($$5 != this.lastChunkPos[$$6] || p_330876_ != this.lastChunkStatus[$$6] || ($$7 = this.lastChunk[$$6]) == null && p_8363_) continue;
            return $$7;
        }
        $$4.incrementCounter("getChunkCacheMiss");
        CompletableFuture<ChunkResult<ChunkAccess>> $$8 = this.getChunkFutureMainThread(p_8360_, p_8361_, p_330876_, p_8363_);
        this.mainThreadProcessor.managedBlock($$8::isDone);
        ChunkResult<ChunkAccess> $$9 = $$8.join();
        ChunkAccess $$10 = $$9.orElse(null);
        if ($$10 == null && p_8363_) {
            throw Util.pauseInIde(new IllegalStateException("Chunk not there when requested: " + $$9.getError()));
        }
        this.storeInCache($$5, $$10, p_330876_);
        return $$10;
    }

    @Override
    @Nullable
    public LevelChunk getChunkNow(int p_8357_, int p_8358_) {
        if (Thread.currentThread() != this.mainThread) {
            return null;
        }
        this.level.getProfiler().incrementCounter("getChunkNow");
        long $$2 = ChunkPos.asLong(p_8357_, p_8358_);
        for (int $$3 = 0; $$3 < 4; ++$$3) {
            if ($$2 != this.lastChunkPos[$$3] || this.lastChunkStatus[$$3] != ChunkStatus.FULL) continue;
            ChunkAccess $$4 = this.lastChunk[$$3];
            return $$4 instanceof LevelChunk ? (LevelChunk)$$4 : null;
        }
        ChunkHolder $$5 = this.getVisibleChunkIfPresent($$2);
        if ($$5 == null) {
            return null;
        }
        ChunkAccess $$6 = $$5.getChunkIfPresent(ChunkStatus.FULL);
        if ($$6 != null) {
            this.storeInCache($$2, $$6, ChunkStatus.FULL);
            if ($$6 instanceof LevelChunk) {
                return (LevelChunk)$$6;
            }
        }
        return null;
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkPos.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunkStatus, null);
        Arrays.fill(this.lastChunk, null);
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getChunkFuture(int p_8432_, int p_8433_, ChunkStatus p_330326_, boolean p_8435_) {
        CompletionStage $$6;
        boolean $$4;
        boolean bl = $$4 = Thread.currentThread() == this.mainThread;
        if ($$4) {
            CompletableFuture<ChunkResult<ChunkAccess>> $$5 = this.getChunkFutureMainThread(p_8432_, p_8433_, p_330326_, p_8435_);
            this.mainThreadProcessor.managedBlock($$5::isDone);
        } else {
            $$6 = CompletableFuture.supplyAsync(() -> this.getChunkFutureMainThread(p_8432_, p_8433_, p_330326_, p_8435_), this.mainThreadProcessor).thenCompose(p_331360_ -> p_331360_);
        }
        return $$6;
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> getChunkFutureMainThread(int p_8457_, int p_8458_, ChunkStatus p_331599_, boolean p_8460_) {
        ChunkPos $$4 = new ChunkPos(p_8457_, p_8458_);
        long $$5 = $$4.toLong();
        int $$6 = ChunkLevel.byStatus(p_331599_);
        ChunkHolder $$7 = this.getVisibleChunkIfPresent($$5);
        if (p_8460_) {
            this.distanceManager.addTicket(TicketType.UNKNOWN, $$4, $$6, $$4);
            if (this.chunkAbsent($$7, $$6)) {
                ProfilerFiller $$8 = this.level.getProfiler();
                $$8.push("chunkLoad");
                this.runDistanceManagerUpdates();
                $$7 = this.getVisibleChunkIfPresent($$5);
                $$8.pop();
                if (this.chunkAbsent($$7, $$6)) {
                    throw Util.pauseInIde(new IllegalStateException("No chunk holder after ticket has been added"));
                }
            }
        }
        if (this.chunkAbsent($$7, $$6)) {
            return GenerationChunkHolder.UNLOADED_CHUNK_FUTURE;
        }
        return $$7.scheduleChunkGenerationTask(p_331599_, this.chunkMap);
    }

    private boolean chunkAbsent(@Nullable ChunkHolder p_8417_, int p_8418_) {
        return p_8417_ == null || p_8417_.getTicketLevel() > p_8418_;
    }

    @Override
    public boolean hasChunk(int p_8429_, int p_8430_) {
        int $$3;
        ChunkHolder $$2 = this.getVisibleChunkIfPresent(new ChunkPos(p_8429_, p_8430_).toLong());
        return !this.chunkAbsent($$2, $$3 = ChunkLevel.byStatus(ChunkStatus.FULL));
    }

    @Override
    @Nullable
    public LightChunk getChunkForLighting(int p_8454_, int p_8455_) {
        long $$2 = ChunkPos.asLong(p_8454_, p_8455_);
        ChunkHolder $$3 = this.getVisibleChunkIfPresent($$2);
        if ($$3 == null) {
            return null;
        }
        return $$3.getChunkIfPresentUnchecked(ChunkStatus.INITIALIZE_LIGHT.getParent());
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public boolean pollTask() {
        return this.mainThreadProcessor.pollTask();
    }

    boolean runDistanceManagerUpdates() {
        boolean $$0 = this.distanceManager.runAllUpdates(this.chunkMap);
        boolean $$1 = this.chunkMap.promoteChunkMap();
        this.chunkMap.runGenerationTasks();
        if ($$0 || $$1) {
            this.clearCache();
            return true;
        }
        return false;
    }

    public boolean isPositionTicking(long p_143240_) {
        ChunkHolder $$1 = this.getVisibleChunkIfPresent(p_143240_);
        if ($$1 == null) {
            return false;
        }
        if (!this.level.shouldTickBlocksAt(p_143240_)) {
            return false;
        }
        return $$1.getTickingChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK).isSuccess();
    }

    public void save(boolean p_8420_) {
        this.runDistanceManagerUpdates();
        this.chunkMap.saveAllChunks(p_8420_);
    }

    @Override
    public void close() throws IOException {
        this.save(true);
        this.lightEngine.close();
        this.chunkMap.close();
    }

    @Override
    public void tick(BooleanSupplier p_201913_, boolean p_201914_) {
        this.level.getProfiler().push("purge");
        if (this.level.tickRateManager().runsNormally() || !p_201914_) {
            this.distanceManager.purgeStaleTickets();
        }
        this.runDistanceManagerUpdates();
        this.level.getProfiler().popPush("chunks");
        if (p_201914_) {
            this.tickChunks();
            this.chunkMap.tick();
        }
        this.level.getProfiler().popPush("unload");
        this.chunkMap.tick(p_201913_);
        this.level.getProfiler().pop();
        this.clearCache();
    }

    private void tickChunks() {
        long $$0 = this.level.getGameTime();
        long $$1 = $$0 - this.lastInhabitedUpdate;
        this.lastInhabitedUpdate = $$0;
        if (this.level.isDebug()) {
            return;
        }
        ProfilerFiller $$2 = this.level.getProfiler();
        $$2.push("pollingChunks");
        $$2.push("filteringLoadedChunks");
        ArrayList $$3 = Lists.newArrayListWithCapacity((int)this.chunkMap.size());
        for (ChunkHolder $$4 : this.chunkMap.getChunks()) {
            LevelChunk $$5 = $$4.getTickingChunk();
            if ($$5 == null) continue;
            $$3.add(new ChunkAndHolder($$5, $$4));
        }
        if (this.level.tickRateManager().runsNormally()) {
            NaturalSpawner.SpawnState $$7;
            $$2.popPush("naturalSpawnCount");
            int $$6 = this.distanceManager.getNaturalSpawnChunkCount();
            this.lastSpawnState = $$7 = NaturalSpawner.createState($$6, this.level.getAllEntities(), this::getFullChunk, new LocalMobCapCalculator(this.chunkMap));
            $$2.popPush("spawnAndTick");
            boolean $$8 = this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
            Util.shuffle($$3, this.level.random);
            int $$9 = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
            boolean $$10 = this.level.getLevelData().getGameTime() % 400L == 0L;
            for (ChunkAndHolder $$11 : $$3) {
                LevelChunk $$12 = $$11.chunk;
                ChunkPos $$13 = $$12.getPos();
                if (!this.level.isNaturalSpawningAllowed($$13) || !this.chunkMap.anyPlayerCloseEnoughForSpawning($$13)) continue;
                $$12.incrementInhabitedTime($$1);
                if ($$8 && (this.spawnEnemies || this.spawnFriendlies) && this.level.getWorldBorder().isWithinBounds($$13)) {
                    NaturalSpawner.spawnForChunk(this.level, $$12, $$7, this.spawnFriendlies, this.spawnEnemies, $$10);
                }
                if (!this.level.shouldTickBlocksAt($$13.toLong())) continue;
                this.level.tickChunk($$12, $$9);
            }
            $$2.popPush("customSpawners");
            if ($$8) {
                this.level.tickCustomSpawners(this.spawnEnemies, this.spawnFriendlies);
            }
        }
        $$2.popPush("broadcast");
        $$3.forEach(p_184022_ -> p_184022_.holder.broadcastChanges(p_184022_.chunk));
        $$2.pop();
        $$2.pop();
    }

    private void getFullChunk(long p_8371_, Consumer<LevelChunk> p_8372_) {
        ChunkHolder $$2 = this.getVisibleChunkIfPresent(p_8371_);
        if ($$2 != null) {
            $$2.getFullChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK).ifSuccess(p_8372_);
        }
    }

    @Override
    public String gatherStats() {
        return Integer.toString(this.getLoadedChunksCount());
    }

    @VisibleForTesting
    public int getPendingTasksCount() {
        return this.mainThreadProcessor.getPendingTasksCount();
    }

    public ChunkGenerator getGenerator() {
        return this.chunkMap.generator();
    }

    public ChunkGeneratorStructureState getGeneratorState() {
        return this.chunkMap.generatorState();
    }

    public RandomState randomState() {
        return this.chunkMap.randomState();
    }

    @Override
    public int getLoadedChunksCount() {
        return this.chunkMap.size();
    }

    public void blockChanged(BlockPos p_8451_) {
        int $$2;
        int $$1 = SectionPos.blockToSectionCoord(p_8451_.getX());
        ChunkHolder $$3 = this.getVisibleChunkIfPresent(ChunkPos.asLong($$1, $$2 = SectionPos.blockToSectionCoord(p_8451_.getZ())));
        if ($$3 != null) {
            $$3.blockChanged(p_8451_);
        }
    }

    @Override
    public void onLightUpdate(LightLayer p_8403_, SectionPos p_8404_) {
        this.mainThreadProcessor.execute(() -> {
            ChunkHolder $$2 = this.getVisibleChunkIfPresent(p_8404_.chunk().toLong());
            if ($$2 != null) {
                $$2.sectionLightChanged(p_8403_, p_8404_.y());
            }
        });
    }

    public <T> void addRegionTicket(TicketType<T> p_8388_, ChunkPos p_8389_, int p_8390_, T p_8391_) {
        this.distanceManager.addRegionTicket(p_8388_, p_8389_, p_8390_, p_8391_);
    }

    public <T> void removeRegionTicket(TicketType<T> p_8439_, ChunkPos p_8440_, int p_8441_, T p_8442_) {
        this.distanceManager.removeRegionTicket(p_8439_, p_8440_, p_8441_, p_8442_);
    }

    @Override
    public void updateChunkForced(ChunkPos p_8400_, boolean p_8401_) {
        this.distanceManager.updateChunkForced(p_8400_, p_8401_);
    }

    public void move(ServerPlayer p_8386_) {
        if (!p_8386_.isRemoved()) {
            this.chunkMap.move(p_8386_);
        }
    }

    public void removeEntity(Entity p_8444_) {
        this.chunkMap.removeEntity(p_8444_);
    }

    public void addEntity(Entity p_8464_) {
        this.chunkMap.addEntity(p_8464_);
    }

    public void broadcastAndSend(Entity p_8395_, Packet<?> p_8396_) {
        this.chunkMap.broadcastAndSend(p_8395_, p_8396_);
    }

    public void broadcast(Entity p_8446_, Packet<?> p_8447_) {
        this.chunkMap.broadcast(p_8446_, p_8447_);
    }

    public void setViewDistance(int p_8355_) {
        this.chunkMap.setServerViewDistance(p_8355_);
    }

    public void setSimulationDistance(int p_184027_) {
        this.distanceManager.updateSimulationDistance(p_184027_);
    }

    @Override
    public void setSpawnSettings(boolean p_8425_, boolean p_8426_) {
        this.spawnEnemies = p_8425_;
        this.spawnFriendlies = p_8426_;
    }

    public String getChunkDebugData(ChunkPos p_8449_) {
        return this.chunkMap.getChunkDebugData(p_8449_);
    }

    public DimensionDataStorage getDataStorage() {
        return this.dataStorage;
    }

    public PoiManager getPoiManager() {
        return this.chunkMap.getPoiManager();
    }

    public ChunkScanAccess chunkScanner() {
        return this.chunkMap.chunkScanner();
    }

    @Nullable
    @VisibleForDebug
    public NaturalSpawner.SpawnState getLastSpawnState() {
        return this.lastSpawnState;
    }

    public void removeTicketsOnClosing() {
        this.distanceManager.removeTicketsOnClosing();
    }

    @Override
    public /* synthetic */ LevelLightEngine getLightEngine() {
        return this.getLightEngine();
    }

    @Override
    public /* synthetic */ BlockGetter getLevel() {
        return this.getLevel();
    }

    final class MainThreadExecutor
    extends BlockableEventLoop<Runnable> {
        MainThreadExecutor(Level p_8494_) {
            super("Chunk source main thread executor for " + String.valueOf(p_8494_.dimension().location()));
        }

        @Override
        public void managedBlock(BooleanSupplier p_347606_) {
            super.managedBlock(() -> MinecraftServer.throwIfFatalException() && p_347606_.getAsBoolean());
        }

        @Override
        protected Runnable wrapRunnable(Runnable p_8506_) {
            return p_8506_;
        }

        @Override
        protected boolean shouldRun(Runnable p_8504_) {
            return true;
        }

        @Override
        protected boolean scheduleExecutables() {
            return true;
        }

        @Override
        protected Thread getRunningThread() {
            return ServerChunkCache.this.mainThread;
        }

        @Override
        protected void doRunTask(Runnable p_8502_) {
            ServerChunkCache.this.level.getProfiler().incrementCounter("runTask");
            super.doRunTask(p_8502_);
        }

        @Override
        protected boolean pollTask() {
            if (ServerChunkCache.this.runDistanceManagerUpdates()) {
                return true;
            }
            ServerChunkCache.this.lightEngine.tryScheduleUpdate();
            return super.pollTask();
        }
    }

    record ChunkAndHolder(LevelChunk chunk, ChunkHolder holder) {
    }
}

