/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Comparators;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.List;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.slf4j.Logger;

public class PlayerChunkSender {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float MIN_CHUNKS_PER_TICK = 0.01f;
    public static final float MAX_CHUNKS_PER_TICK = 64.0f;
    private static final float START_CHUNKS_PER_TICK = 9.0f;
    private static final int MAX_UNACKNOWLEDGED_BATCHES = 10;
    private final LongSet pendingChunks = new LongOpenHashSet();
    private final boolean memoryConnection;
    private float desiredChunksPerTick = 9.0f;
    private float batchQuota;
    private int unacknowledgedBatches;
    private int maxUnacknowledgedBatches = 1;

    public PlayerChunkSender(boolean p_294754_) {
        this.memoryConnection = p_294754_;
    }

    public void markChunkPendingToSend(LevelChunk p_296454_) {
        this.pendingChunks.add(p_296454_.getPos().toLong());
    }

    public void dropChunk(ServerPlayer p_294214_, ChunkPos p_294933_) {
        if (!this.pendingChunks.remove(p_294933_.toLong()) && p_294214_.isAlive()) {
            p_294214_.connection.send(new ClientboundForgetLevelChunkPacket(p_294933_));
        }
    }

    public void sendNextChunks(ServerPlayer p_296009_) {
        if (this.unacknowledgedBatches >= this.maxUnacknowledgedBatches) {
            return;
        }
        float $$1 = Math.max(1.0f, this.desiredChunksPerTick);
        this.batchQuota = Math.min(this.batchQuota + this.desiredChunksPerTick, $$1);
        if (this.batchQuota < 1.0f) {
            return;
        }
        if (this.pendingChunks.isEmpty()) {
            return;
        }
        ServerLevel $$2 = p_296009_.serverLevel();
        ChunkMap $$3 = $$2.getChunkSource().chunkMap;
        List<LevelChunk> $$4 = this.collectChunksToSend($$3, p_296009_.chunkPosition());
        if ($$4.isEmpty()) {
            return;
        }
        ServerGamePacketListenerImpl $$5 = p_296009_.connection;
        ++this.unacknowledgedBatches;
        $$5.send(ClientboundChunkBatchStartPacket.INSTANCE);
        for (LevelChunk $$6 : $$4) {
            PlayerChunkSender.sendChunk($$5, $$2, $$6);
        }
        $$5.send(new ClientboundChunkBatchFinishedPacket($$4.size()));
        this.batchQuota -= (float)$$4.size();
    }

    private static void sendChunk(ServerGamePacketListenerImpl p_295237_, ServerLevel p_294963_, LevelChunk p_295144_) {
        p_295237_.send(new ClientboundLevelChunkWithLightPacket(p_295144_, p_294963_.getLightEngine(), null, null));
        ChunkPos $$3 = p_295144_.getPos();
        DebugPackets.sendPoiPacketsForChunk(p_294963_, $$3);
    }

    /*
     * Unable to fully structure code
     */
    private List<LevelChunk> collectChunksToSend(ChunkMap p_296053_, ChunkPos p_295659_) {
        $$2 = Mth.floor(this.batchQuota);
        if (this.memoryConnection) ** GOTO lbl7
        if (this.pendingChunks.size() <= $$2) {
lbl7:
            // 2 sources

            $$3 = this.pendingChunks.longStream().mapToObj((LongFunction<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, (J)Ljava/lang/Object;, getChunkToSend(long ), (J)Lnet/minecraft/world/level/chunk/LevelChunk;)((ChunkMap)p_296053_)).filter((Predicate<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lnet/minecraft/world/level/chunk/LevelChunk;)Z)()).sorted(Comparator.comparingInt((ToIntFunction<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$collectChunksToSend$0(net.minecraft.world.level.ChunkPos net.minecraft.world.level.chunk.LevelChunk ), (Lnet/minecraft/world/level/chunk/LevelChunk;)I)((ChunkPos)p_295659_))).toList();
        } else {
            $$4 = ((List)this.pendingChunks.stream().collect(Comparators.least((int)$$2, Comparator.comparingInt((ToIntFunction<Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, distanceSquared(long ), (Ljava/lang/Long;)I)((ChunkPos)p_295659_))))).stream().mapToLong((ToLongFunction<Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, longValue(), (Ljava/lang/Long;)J)()).mapToObj((LongFunction<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, (J)Ljava/lang/Object;, getChunkToSend(long ), (J)Lnet/minecraft/world/level/chunk/LevelChunk;)((ChunkMap)p_296053_)).filter((Predicate<LevelChunk>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lnet/minecraft/world/level/chunk/LevelChunk;)Z)()).toList();
        }
        for (LevelChunk $$5 : $$4) {
            this.pendingChunks.remove($$5.getPos().toLong());
        }
        return $$4;
    }

    public void onChunkBatchReceivedByClient(float p_294462_) {
        --this.unacknowledgedBatches;
        float f = this.desiredChunksPerTick = Double.isNaN(p_294462_) ? 0.01f : Mth.clamp(p_294462_, 0.01f, 64.0f);
        if (this.unacknowledgedBatches == 0) {
            this.batchQuota = 1.0f;
        }
        this.maxUnacknowledgedBatches = 10;
    }

    public boolean isPending(long p_296128_) {
        return this.pendingChunks.contains(p_296128_);
    }

    private static /* synthetic */ int lambda$collectChunksToSend$0(ChunkPos p_296268_, LevelChunk p_294268_) {
        return p_296268_.distanceSquared(p_294268_.getPos());
    }
}

