/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class MinecartItem
extends Item {
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        /*
         * WARNING - void declaration
         */
        @Override
        public ItemStack execute(BlockSource p_302448_, ItemStack p_42950_) {
            void $$17;
            RailShape $$10;
            Direction $$2 = p_302448_.state().getValue(DispenserBlock.FACING);
            ServerLevel $$3 = p_302448_.level();
            Vec3 $$4 = p_302448_.center();
            double $$5 = $$4.x() + (double)$$2.getStepX() * 1.125;
            double $$6 = Math.floor($$4.y()) + (double)$$2.getStepY();
            double $$7 = $$4.z() + (double)$$2.getStepZ() * 1.125;
            BlockPos $$8 = p_302448_.pos().relative($$2);
            BlockState $$9 = $$3.getBlockState($$8);
            RailShape railShape = $$10 = $$9.getBlock() instanceof BaseRailBlock ? $$9.getValue(((BaseRailBlock)$$9.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            if ($$9.is(BlockTags.RAILS)) {
                if ($$10.isAscending()) {
                    double $$11 = 0.6;
                } else {
                    double $$12 = 0.1;
                }
            } else if ($$9.isAir() && $$3.getBlockState($$8.below()).is(BlockTags.RAILS)) {
                RailShape $$14;
                BlockState $$13 = $$3.getBlockState($$8.below());
                RailShape railShape2 = $$14 = $$13.getBlock() instanceof BaseRailBlock ? $$13.getValue(((BaseRailBlock)$$13.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
                if ($$2 == Direction.DOWN || !$$14.isAscending()) {
                    double $$15 = -0.9;
                } else {
                    double $$16 = -0.4;
                }
            } else {
                return this.defaultDispenseItemBehavior.dispense(p_302448_, p_42950_);
            }
            AbstractMinecart $$18 = AbstractMinecart.createMinecart($$3, $$5, $$6 + $$17, $$7, ((MinecartItem)p_42950_.getItem()).type, p_42950_, null);
            $$3.addFreshEntity($$18);
            p_42950_.shrink(1);
            return p_42950_;
        }

        @Override
        protected void playSound(BlockSource p_302470_) {
            p_302470_.level().levelEvent(1000, p_302470_.pos(), 0);
        }
    };
    final AbstractMinecart.Type type;

    public MinecartItem(AbstractMinecart.Type p_42938_, Item.Properties p_42939_) {
        super(p_42939_);
        this.type = p_42938_;
        DispenserBlock.registerBehavior(this, DISPENSE_ITEM_BEHAVIOR);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_42943_) {
        BlockPos $$2;
        Level $$1 = p_42943_.getLevel();
        BlockState $$3 = $$1.getBlockState($$2 = p_42943_.getClickedPos());
        if (!$$3.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack $$4 = p_42943_.getItemInHand();
        if ($$1 instanceof ServerLevel) {
            ServerLevel $$5 = (ServerLevel)$$1;
            RailShape $$6 = $$3.getBlock() instanceof BaseRailBlock ? $$3.getValue(((BaseRailBlock)$$3.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            double $$7 = 0.0;
            if ($$6.isAscending()) {
                $$7 = 0.5;
            }
            AbstractMinecart $$8 = AbstractMinecart.createMinecart($$5, (double)$$2.getX() + 0.5, (double)$$2.getY() + 0.0625 + $$7, (double)$$2.getZ() + 0.5, this.type, $$4, p_42943_.getPlayer());
            $$5.addFreshEntity($$8);
            $$5.gameEvent(GameEvent.ENTITY_PLACE, $$2, GameEvent.Context.of(p_42943_.getPlayer(), $$5.getBlockState($$2.below())));
        }
        $$4.shrink(1);
        return InteractionResult.sidedSuccess($$1.isClientSide);
    }
}

