/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public final class ItemContainerContents {
    private static final int NO_SLOT = -1;
    private static final int MAX_SIZE = 256;
    public static final ItemContainerContents EMPTY = new ItemContainerContents(NonNullList.create());
    public static final Codec<ItemContainerContents> CODEC = Slot.CODEC.sizeLimitedListOf(256).xmap(ItemContainerContents::fromSlots, ItemContainerContents::asSlots);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemContainerContents> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list(256)).map(ItemContainerContents::new, p_331691_ -> p_331691_.items);
    private final NonNullList<ItemStack> items;
    private final int hashCode;

    private ItemContainerContents(NonNullList<ItemStack> p_332193_) {
        if (p_332193_.size() > 256) {
            throw new IllegalArgumentException("Got " + p_332193_.size() + " items, but maximum is 256");
        }
        this.items = p_332193_;
        this.hashCode = ItemStack.hashStackList(p_332193_);
    }

    private ItemContainerContents(int p_331689_) {
        this(NonNullList.withSize(p_331689_, ItemStack.EMPTY));
    }

    private ItemContainerContents(List<ItemStack> p_331046_) {
        this(p_331046_.size());
        for (int $$1 = 0; $$1 < p_331046_.size(); ++$$1) {
            this.items.set($$1, p_331046_.get($$1));
        }
    }

    private static ItemContainerContents fromSlots(List<Slot> p_331424_) {
        OptionalInt $$1 = p_331424_.stream().mapToInt(Slot::index).max();
        if ($$1.isEmpty()) {
            return EMPTY;
        }
        ItemContainerContents $$2 = new ItemContainerContents($$1.getAsInt() + 1);
        for (Slot $$3 : p_331424_) {
            $$2.items.set($$3.index(), $$3.item());
        }
        return $$2;
    }

    public static ItemContainerContents fromItems(List<ItemStack> p_340879_) {
        int $$1 = ItemContainerContents.findLastNonEmptySlot(p_340879_);
        if ($$1 == -1) {
            return EMPTY;
        }
        ItemContainerContents $$2 = new ItemContainerContents($$1 + 1);
        for (int $$3 = 0; $$3 <= $$1; ++$$3) {
            $$2.items.set($$3, p_340879_.get($$3).copy());
        }
        return $$2;
    }

    private static int findLastNonEmptySlot(List<ItemStack> p_340916_) {
        for (int $$1 = p_340916_.size() - 1; $$1 >= 0; --$$1) {
            if (p_340916_.get($$1).isEmpty()) continue;
            return $$1;
        }
        return -1;
    }

    private List<Slot> asSlots() {
        ArrayList<Slot> $$0 = new ArrayList<Slot>();
        for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
            ItemStack $$2 = this.items.get($$1);
            if ($$2.isEmpty()) continue;
            $$0.add(new Slot($$1, $$2));
        }
        return $$0;
    }

    public void copyInto(NonNullList<ItemStack> p_330513_) {
        for (int $$1 = 0; $$1 < p_330513_.size(); ++$$1) {
            ItemStack $$2 = $$1 < this.items.size() ? this.items.get($$1) : ItemStack.EMPTY;
            p_330513_.set($$1, $$2.copy());
        }
    }

    public ItemStack copyOne() {
        return this.items.isEmpty() ? ItemStack.EMPTY : this.items.get(0).copy();
    }

    public Stream<ItemStack> stream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Stream<ItemStack> nonEmptyStream() {
        return this.items.stream().filter(p_331322_ -> !p_331322_.isEmpty()).map(ItemStack::copy);
    }

    public Iterable<ItemStack> nonEmptyItems() {
        return Iterables.filter(this.items, p_331420_ -> !p_331420_.isEmpty());
    }

    public Iterable<ItemStack> nonEmptyItemsCopy() {
        return Iterables.transform(this.nonEmptyItems(), ItemStack::copy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_331711_) {
        if (this == p_331711_) {
            return true;
        }
        if (!(p_331711_ instanceof ItemContainerContents)) return false;
        ItemContainerContents $$1 = (ItemContainerContents)p_331711_;
        if (!ItemStack.listMatches(this.items, $$1.items)) return false;
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    record Slot(int index, ItemStack item) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(p_331695_ -> p_331695_.group((App)Codec.intRange((int)0, (int)255).fieldOf("slot").forGetter(Slot::index), (App)ItemStack.CODEC.fieldOf("item").forGetter(Slot::item)).apply((Applicative)p_331695_, Slot::new));
    }
}

