/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record SpawnParticlesEffect(ParticleOptions particle, PositionSource horizontalPosition, PositionSource verticalPosition, VelocitySource horizontalVelocity, VelocitySource verticalVelocity, FloatProvider speed) implements EnchantmentEntityEffect
{
    public static final MapCodec<SpawnParticlesEffect> CODEC = RecordCodecBuilder.mapCodec(p_345987_ -> p_345987_.group((App)ParticleTypes.CODEC.fieldOf("particle").forGetter(SpawnParticlesEffect::particle), (App)PositionSource.CODEC.fieldOf("horizontal_position").forGetter(SpawnParticlesEffect::horizontalPosition), (App)PositionSource.CODEC.fieldOf("vertical_position").forGetter(SpawnParticlesEffect::verticalPosition), (App)VelocitySource.CODEC.fieldOf("horizontal_velocity").forGetter(SpawnParticlesEffect::horizontalVelocity), (App)VelocitySource.CODEC.fieldOf("vertical_velocity").forGetter(SpawnParticlesEffect::verticalVelocity), (App)FloatProvider.CODEC.optionalFieldOf("speed", (Object)ConstantFloat.ZERO).forGetter(SpawnParticlesEffect::speed)).apply((Applicative)p_345987_, SpawnParticlesEffect::new));

    public static PositionSource offsetFromEntityPosition(float p_345365_) {
        return new PositionSource(PositionSourceType.ENTITY_POSITION, p_345365_, 1.0f);
    }

    public static PositionSource inBoundingBox() {
        return new PositionSource(PositionSourceType.BOUNDING_BOX, 0.0f, 1.0f);
    }

    public static VelocitySource movementScaled(float p_345360_) {
        return new VelocitySource(p_345360_, ConstantFloat.ZERO);
    }

    public static VelocitySource fixedVelocity(FloatProvider p_345397_) {
        return new VelocitySource(0.0f, p_345397_);
    }

    @Override
    public void apply(ServerLevel p_345529_, int p_346425_, EnchantedItemInUse p_346391_, Entity p_345668_, Vec3 p_344842_) {
        RandomSource $$5 = p_345668_.getRandom();
        Vec3 $$6 = p_345668_.getKnownMovement();
        float $$7 = p_345668_.getBbWidth();
        float $$8 = p_345668_.getBbHeight();
        p_345529_.sendParticles(this.particle, this.horizontalPosition.getCoordinate(p_344842_.x(), p_344842_.x(), $$7, $$5), this.verticalPosition.getCoordinate(p_344842_.y(), p_344842_.y() + (double)($$8 / 2.0f), $$8, $$5), this.horizontalPosition.getCoordinate(p_344842_.z(), p_344842_.z(), $$7, $$5), 0, this.horizontalVelocity.getVelocity($$6.x(), $$5), this.verticalVelocity.getVelocity($$6.y(), $$5), this.horizontalVelocity.getVelocity($$6.z(), $$5), this.speed.sample($$5));
    }

    public MapCodec<SpawnParticlesEffect> codec() {
        return CODEC;
    }

    public record PositionSource(PositionSourceType type, float offset, float scale) {
        public static final MapCodec<PositionSource> CODEC = RecordCodecBuilder.mapCodec(p_345074_ -> p_345074_.group((App)PositionSourceType.CODEC.fieldOf("type").forGetter(PositionSource::type), (App)Codec.FLOAT.optionalFieldOf("offset", (Object)Float.valueOf(0.0f)).forGetter(PositionSource::offset), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(PositionSource::scale)).apply((Applicative)p_345074_, PositionSource::new)).validate(p_345424_ -> {
            if (p_345424_.type() == PositionSourceType.ENTITY_POSITION && p_345424_.scale() != 1.0f) {
                return DataResult.error(() -> "Cannot scale an entity position coordinate source");
            }
            return DataResult.success((Object)p_345424_);
        });

        public double getCoordinate(double p_345009_, double p_352916_, float p_344887_, RandomSource p_345452_) {
            return this.type.getCoordinate(p_345009_, p_352916_, p_344887_ * this.scale, p_345452_) + (double)this.offset;
        }
    }

    public record VelocitySource(float movementScale, FloatProvider base) {
        public static final MapCodec<VelocitySource> CODEC = RecordCodecBuilder.mapCodec(p_346005_ -> p_346005_.group((App)Codec.FLOAT.optionalFieldOf("movement_scale", (Object)Float.valueOf(0.0f)).forGetter(VelocitySource::movementScale), (App)FloatProvider.CODEC.optionalFieldOf("base", (Object)ConstantFloat.ZERO).forGetter(VelocitySource::base)).apply((Applicative)p_346005_, VelocitySource::new));

        public double getVelocity(double p_345309_, RandomSource p_345168_) {
            return p_345309_ * (double)this.movementScale + (double)this.base.sample(p_345168_);
        }
    }

    public static enum PositionSourceType implements StringRepresentable
    {
        ENTITY_POSITION("entity_position", (p_344963_, p_352938_, p_346310_, p_345258_) -> p_344963_),
        BOUNDING_BOX("in_bounding_box", (p_345669_, p_352951_, p_345281_, p_345162_) -> p_352951_ + (p_345162_.nextDouble() - 0.5) * (double)p_345281_);

        public static final Codec<PositionSourceType> CODEC;
        private final String id;
        private final CoordinateSource source;

        private PositionSourceType(String p_345226_, CoordinateSource p_346335_) {
            this.id = p_345226_;
            this.source = p_346335_;
        }

        public double getCoordinate(double p_345237_, double p_352964_, float p_345722_, RandomSource p_345004_) {
            return this.source.getCoordinate(p_345237_, p_352964_, p_345722_, p_345004_);
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(PositionSourceType::values);
        }

        @FunctionalInterface
        static interface CoordinateSource {
            public double getCoordinate(double var1, double var3, float var5, RandomSource var6);
        }
    }
}

