/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedStoneWireBlock
extends Block {
    public static final MapCodec<RedStoneWireBlock> CODEC = RedStoneWireBlock.simpleCodec(RedStoneWireBlock::new);
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    protected static final int H = 1;
    protected static final int W = 3;
    protected static final int E = 13;
    protected static final int N = 3;
    protected static final int S = 13;
    private static final VoxelShape SHAPE_DOT = Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<Direction, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)Direction.SOUTH, (Object)Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)Direction.EAST, (Object)Block.box(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)Direction.WEST, (Object)Block.box(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<Direction, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.NORTH), Block.box(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)Direction.SOUTH, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.SOUTH), Block.box(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)Direction.EAST, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.EAST), Block.box(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)Direction.WEST, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.WEST), Block.box(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private static final Map<BlockState, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private static final Vec3[] COLORS = Util.make(new Vec3[16], p_154319_ -> {
        for (int $$1 = 0; $$1 <= 15; ++$$1) {
            float $$2;
            float $$3 = $$2 * 0.6f + (($$2 = (float)$$1 / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float $$4 = Mth.clamp($$2 * $$2 * 0.7f - 0.5f, 0.0f, 1.0f);
            float $$5 = Mth.clamp($$2 * $$2 * 0.6f - 0.7f, 0.0f, 1.0f);
            p_154319_[$$1] = new Vec3($$3, $$4, $$5);
        }
    });
    private static final float PARTICLE_DENSITY = 0.2f;
    private final BlockState crossState;
    private boolean shouldSignal = true;

    public MapCodec<RedStoneWireBlock> codec() {
        return CODEC;
    }

    public RedStoneWireBlock(BlockBehaviour.Properties p_55511_) {
        super(p_55511_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, RedstoneSide.NONE)).setValue(EAST, RedstoneSide.NONE)).setValue(SOUTH, RedstoneSide.NONE)).setValue(WEST, RedstoneSide.NONE)).setValue(POWER, 0));
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, RedstoneSide.SIDE)).setValue(EAST, RedstoneSide.SIDE)).setValue(SOUTH, RedstoneSide.SIDE)).setValue(WEST, RedstoneSide.SIDE);
        for (BlockState $$1 : this.getStateDefinition().getPossibleStates()) {
            if ($$1.getValue(POWER) != 0) continue;
            SHAPES_CACHE.put($$1, this.calculateShape($$1));
        }
    }

    private VoxelShape calculateShape(BlockState p_55643_) {
        VoxelShape $$1 = SHAPE_DOT;
        for (Direction $$2 : Direction.Plane.HORIZONTAL) {
            RedstoneSide $$3 = (RedstoneSide)p_55643_.getValue(PROPERTY_BY_DIRECTION.get($$2));
            if ($$3 == RedstoneSide.SIDE) {
                $$1 = Shapes.or($$1, SHAPES_FLOOR.get($$2));
                continue;
            }
            if ($$3 != RedstoneSide.UP) continue;
            $$1 = Shapes.or($$1, SHAPES_UP.get($$2));
        }
        return $$1;
    }

    @Override
    protected VoxelShape getShape(BlockState p_55620_, BlockGetter p_55621_, BlockPos p_55622_, CollisionContext p_55623_) {
        return SHAPES_CACHE.get(p_55620_.setValue(POWER, 0));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_55513_) {
        return this.getConnectionState(p_55513_.getLevel(), this.crossState, p_55513_.getClickedPos());
    }

    private BlockState getConnectionState(BlockGetter p_55515_, BlockState p_55516_, BlockPos p_55517_) {
        boolean $$9;
        boolean $$3 = RedStoneWireBlock.isDot(p_55516_);
        p_55516_ = this.getMissingConnections(p_55515_, (BlockState)this.defaultBlockState().setValue(POWER, p_55516_.getValue(POWER)), p_55517_);
        if ($$3 && RedStoneWireBlock.isDot(p_55516_)) {
            return p_55516_;
        }
        boolean $$4 = p_55516_.getValue(NORTH).isConnected();
        boolean $$5 = p_55516_.getValue(SOUTH).isConnected();
        boolean $$6 = p_55516_.getValue(EAST).isConnected();
        boolean $$7 = p_55516_.getValue(WEST).isConnected();
        boolean $$8 = !$$4 && !$$5;
        boolean bl = $$9 = !$$6 && !$$7;
        if (!$$7 && $$8) {
            p_55516_ = (BlockState)p_55516_.setValue(WEST, RedstoneSide.SIDE);
        }
        if (!$$6 && $$8) {
            p_55516_ = (BlockState)p_55516_.setValue(EAST, RedstoneSide.SIDE);
        }
        if (!$$4 && $$9) {
            p_55516_ = (BlockState)p_55516_.setValue(NORTH, RedstoneSide.SIDE);
        }
        if (!$$5 && $$9) {
            p_55516_ = (BlockState)p_55516_.setValue(SOUTH, RedstoneSide.SIDE);
        }
        return p_55516_;
    }

    private BlockState getMissingConnections(BlockGetter p_55609_, BlockState p_55610_, BlockPos p_55611_) {
        boolean $$3 = !p_55609_.getBlockState(p_55611_.above()).isRedstoneConductor(p_55609_, p_55611_);
        for (Direction $$4 : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)p_55610_.getValue(PROPERTY_BY_DIRECTION.get($$4))).isConnected()) continue;
            RedstoneSide $$5 = this.getConnectingSide(p_55609_, p_55611_, $$4, $$3);
            p_55610_ = (BlockState)p_55610_.setValue(PROPERTY_BY_DIRECTION.get($$4), $$5);
        }
        return p_55610_;
    }

    @Override
    protected BlockState updateShape(BlockState p_55598_, Direction p_55599_, BlockState p_55600_, LevelAccessor p_55601_, BlockPos p_55602_, BlockPos p_55603_) {
        if (p_55599_ == Direction.DOWN) {
            if (!this.canSurviveOn(p_55601_, p_55603_, p_55600_)) {
                return Blocks.AIR.defaultBlockState();
            }
            return p_55598_;
        }
        if (p_55599_ == Direction.UP) {
            return this.getConnectionState(p_55601_, p_55598_, p_55602_);
        }
        RedstoneSide $$6 = this.getConnectingSide(p_55601_, p_55602_, p_55599_);
        if ($$6.isConnected() == ((RedstoneSide)p_55598_.getValue(PROPERTY_BY_DIRECTION.get(p_55599_))).isConnected() && !RedStoneWireBlock.isCross(p_55598_)) {
            return (BlockState)p_55598_.setValue(PROPERTY_BY_DIRECTION.get(p_55599_), $$6);
        }
        return this.getConnectionState(p_55601_, (BlockState)((BlockState)this.crossState.setValue(POWER, p_55598_.getValue(POWER))).setValue(PROPERTY_BY_DIRECTION.get(p_55599_), $$6), p_55602_);
    }

    private static boolean isCross(BlockState p_55645_) {
        return p_55645_.getValue(NORTH).isConnected() && p_55645_.getValue(SOUTH).isConnected() && p_55645_.getValue(EAST).isConnected() && p_55645_.getValue(WEST).isConnected();
    }

    private static boolean isDot(BlockState p_55647_) {
        return !p_55647_.getValue(NORTH).isConnected() && !p_55647_.getValue(SOUTH).isConnected() && !p_55647_.getValue(EAST).isConnected() && !p_55647_.getValue(WEST).isConnected();
    }

    @Override
    protected void updateIndirectNeighbourShapes(BlockState p_55579_, LevelAccessor p_55580_, BlockPos p_55581_, int p_55582_, int p_55583_) {
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        for (Direction $$6 : Direction.Plane.HORIZONTAL) {
            RedstoneSide $$7 = (RedstoneSide)p_55579_.getValue(PROPERTY_BY_DIRECTION.get($$6));
            if ($$7 == RedstoneSide.NONE || p_55580_.getBlockState($$5.setWithOffset((Vec3i)p_55581_, $$6)).is(this)) continue;
            $$5.move(Direction.DOWN);
            BlockState $$8 = p_55580_.getBlockState($$5);
            if ($$8.is(this)) {
                Vec3i $$9 = $$5.relative($$6.getOpposite());
                p_55580_.neighborShapeChanged($$6.getOpposite(), p_55580_.getBlockState((BlockPos)$$9), $$5, (BlockPos)$$9, p_55582_, p_55583_);
            }
            $$5.setWithOffset((Vec3i)p_55581_, $$6).move(Direction.UP);
            BlockState $$10 = p_55580_.getBlockState($$5);
            if (!$$10.is(this)) continue;
            Vec3i $$11 = $$5.relative($$6.getOpposite());
            p_55580_.neighborShapeChanged($$6.getOpposite(), p_55580_.getBlockState((BlockPos)$$11), $$5, (BlockPos)$$11, p_55582_, p_55583_);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter p_55519_, BlockPos p_55520_, Direction p_55521_) {
        return this.getConnectingSide(p_55519_, p_55520_, p_55521_, !p_55519_.getBlockState(p_55520_.above()).isRedstoneConductor(p_55519_, p_55520_));
    }

    private RedstoneSide getConnectingSide(BlockGetter p_55523_, BlockPos p_55524_, Direction p_55525_, boolean p_55526_) {
        BlockPos $$4 = p_55524_.relative(p_55525_);
        BlockState $$5 = p_55523_.getBlockState($$4);
        if (p_55526_) {
            boolean $$6;
            boolean bl = $$6 = $$5.getBlock() instanceof TrapDoorBlock || this.canSurviveOn(p_55523_, $$4, $$5);
            if ($$6 && RedStoneWireBlock.shouldConnectTo(p_55523_.getBlockState($$4.above()))) {
                if ($$5.isFaceSturdy(p_55523_, $$4, p_55525_.getOpposite())) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        if (RedStoneWireBlock.shouldConnectTo($$5, p_55525_) || !$$5.isRedstoneConductor(p_55523_, $$4) && RedStoneWireBlock.shouldConnectTo(p_55523_.getBlockState($$4.below()))) {
            return RedstoneSide.SIDE;
        }
        return RedstoneSide.NONE;
    }

    @Override
    protected boolean canSurvive(BlockState p_55585_, LevelReader p_55586_, BlockPos p_55587_) {
        BlockPos $$3 = p_55587_.below();
        BlockState $$4 = p_55586_.getBlockState($$3);
        return this.canSurviveOn(p_55586_, $$3, $$4);
    }

    private boolean canSurviveOn(BlockGetter p_55613_, BlockPos p_55614_, BlockState p_55615_) {
        return p_55615_.isFaceSturdy(p_55613_, p_55614_, Direction.UP) || p_55615_.is(Blocks.HOPPER);
    }

    private void updatePowerStrength(Level p_55531_, BlockPos p_55532_, BlockState p_55533_) {
        int $$3 = this.calculateTargetStrength(p_55531_, p_55532_);
        if (p_55533_.getValue(POWER) != $$3) {
            if (p_55531_.getBlockState(p_55532_) == p_55533_) {
                p_55531_.setBlock(p_55532_, (BlockState)p_55533_.setValue(POWER, $$3), 2);
            }
            HashSet $$4 = Sets.newHashSet();
            $$4.add(p_55532_);
            for (Direction $$5 : Direction.values()) {
                $$4.add(p_55532_.relative($$5));
            }
            for (BlockPos $$6 : $$4) {
                p_55531_.updateNeighborsAt($$6, this);
            }
        }
    }

    private int calculateTargetStrength(Level p_55528_, BlockPos p_55529_) {
        this.shouldSignal = false;
        int $$2 = p_55528_.getBestNeighborSignal(p_55529_);
        this.shouldSignal = true;
        int $$3 = 0;
        if ($$2 < 15) {
            for (Direction $$4 : Direction.Plane.HORIZONTAL) {
                BlockPos $$5 = p_55529_.relative($$4);
                BlockState $$6 = p_55528_.getBlockState($$5);
                $$3 = Math.max($$3, this.getWireSignal($$6));
                BlockPos $$7 = p_55529_.above();
                if ($$6.isRedstoneConductor(p_55528_, $$5) && !p_55528_.getBlockState($$7).isRedstoneConductor(p_55528_, $$7)) {
                    $$3 = Math.max($$3, this.getWireSignal(p_55528_.getBlockState($$5.above())));
                    continue;
                }
                if ($$6.isRedstoneConductor(p_55528_, $$5)) continue;
                $$3 = Math.max($$3, this.getWireSignal(p_55528_.getBlockState($$5.below())));
            }
        }
        return Math.max($$2, $$3 - 1);
    }

    private int getWireSignal(BlockState p_55649_) {
        return p_55649_.is(this) ? p_55649_.getValue(POWER) : 0;
    }

    private void checkCornerChangeAt(Level p_55617_, BlockPos p_55618_) {
        if (!p_55617_.getBlockState(p_55618_).is(this)) {
            return;
        }
        p_55617_.updateNeighborsAt(p_55618_, this);
        for (Direction $$2 : Direction.values()) {
            p_55617_.updateNeighborsAt(p_55618_.relative($$2), this);
        }
    }

    @Override
    protected void onPlace(BlockState p_55630_, Level p_55631_, BlockPos p_55632_, BlockState p_55633_, boolean p_55634_) {
        if (p_55633_.is(p_55630_.getBlock()) || p_55631_.isClientSide) {
            return;
        }
        this.updatePowerStrength(p_55631_, p_55632_, p_55630_);
        for (Direction $$5 : Direction.Plane.VERTICAL) {
            p_55631_.updateNeighborsAt(p_55632_.relative($$5), this);
        }
        this.updateNeighborsOfNeighboringWires(p_55631_, p_55632_);
    }

    @Override
    protected void onRemove(BlockState p_55568_, Level p_55569_, BlockPos p_55570_, BlockState p_55571_, boolean p_55572_) {
        if (p_55572_ || p_55568_.is(p_55571_.getBlock())) {
            return;
        }
        super.onRemove(p_55568_, p_55569_, p_55570_, p_55571_, p_55572_);
        if (p_55569_.isClientSide) {
            return;
        }
        for (Direction $$5 : Direction.values()) {
            p_55569_.updateNeighborsAt(p_55570_.relative($$5), this);
        }
        this.updatePowerStrength(p_55569_, p_55570_, p_55568_);
        this.updateNeighborsOfNeighboringWires(p_55569_, p_55570_);
    }

    private void updateNeighborsOfNeighboringWires(Level p_55638_, BlockPos p_55639_) {
        for (Direction $$2 : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(p_55638_, p_55639_.relative($$2));
        }
        for (Direction $$3 : Direction.Plane.HORIZONTAL) {
            BlockPos $$4 = p_55639_.relative($$3);
            if (p_55638_.getBlockState($$4).isRedstoneConductor(p_55638_, $$4)) {
                this.checkCornerChangeAt(p_55638_, $$4.above());
                continue;
            }
            this.checkCornerChangeAt(p_55638_, $$4.below());
        }
    }

    @Override
    protected void neighborChanged(BlockState p_55561_, Level p_55562_, BlockPos p_55563_, Block p_55564_, BlockPos p_55565_, boolean p_55566_) {
        if (p_55562_.isClientSide) {
            return;
        }
        if (p_55561_.canSurvive(p_55562_, p_55563_)) {
            this.updatePowerStrength(p_55562_, p_55563_, p_55561_);
        } else {
            RedStoneWireBlock.dropResources(p_55561_, p_55562_, p_55563_);
            p_55562_.removeBlock(p_55563_, false);
        }
    }

    @Override
    protected int getDirectSignal(BlockState p_55625_, BlockGetter p_55626_, BlockPos p_55627_, Direction p_55628_) {
        if (!this.shouldSignal) {
            return 0;
        }
        return p_55625_.getSignal(p_55626_, p_55627_, p_55628_);
    }

    @Override
    protected int getSignal(BlockState p_55549_, BlockGetter p_55550_, BlockPos p_55551_, Direction p_55552_) {
        if (!this.shouldSignal || p_55552_ == Direction.DOWN) {
            return 0;
        }
        int $$4 = p_55549_.getValue(POWER);
        if ($$4 == 0) {
            return 0;
        }
        if (p_55552_ == Direction.UP || ((RedstoneSide)this.getConnectionState(p_55550_, p_55549_, p_55551_).getValue(PROPERTY_BY_DIRECTION.get(p_55552_.getOpposite()))).isConnected()) {
            return $$4;
        }
        return 0;
    }

    protected static boolean shouldConnectTo(BlockState p_55641_) {
        return RedStoneWireBlock.shouldConnectTo(p_55641_, null);
    }

    protected static boolean shouldConnectTo(BlockState p_55595_, @Nullable Direction p_55596_) {
        if (p_55595_.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (p_55595_.is(Blocks.REPEATER)) {
            Direction $$2 = p_55595_.getValue(RepeaterBlock.FACING);
            return $$2 == p_55596_ || $$2.getOpposite() == p_55596_;
        }
        if (p_55595_.is(Blocks.OBSERVER)) {
            return p_55596_ == p_55595_.getValue(ObserverBlock.FACING);
        }
        return p_55595_.isSignalSource() && p_55596_ != null;
    }

    @Override
    protected boolean isSignalSource(BlockState p_55636_) {
        return this.shouldSignal;
    }

    public static int getColorForPower(int p_55607_) {
        Vec3 $$1 = COLORS[p_55607_];
        return Mth.color((float)$$1.x(), (float)$$1.y(), (float)$$1.z());
    }

    private void spawnParticlesAlongLine(Level p_221923_, RandomSource p_221924_, BlockPos p_221925_, Vec3 p_221926_, Direction p_221927_, Direction p_221928_, float p_221929_, float p_221930_) {
        float $$8 = p_221930_ - p_221929_;
        if (p_221924_.nextFloat() >= 0.2f * $$8) {
            return;
        }
        float $$9 = 0.4375f;
        float $$10 = p_221929_ + $$8 * p_221924_.nextFloat();
        double $$11 = 0.5 + (double)(0.4375f * (float)p_221927_.getStepX()) + (double)($$10 * (float)p_221928_.getStepX());
        double $$12 = 0.5 + (double)(0.4375f * (float)p_221927_.getStepY()) + (double)($$10 * (float)p_221928_.getStepY());
        double $$13 = 0.5 + (double)(0.4375f * (float)p_221927_.getStepZ()) + (double)($$10 * (float)p_221928_.getStepZ());
        p_221923_.addParticle(new DustParticleOptions(p_221926_.toVector3f(), 1.0f), (double)p_221925_.getX() + $$11, (double)p_221925_.getY() + $$12, (double)p_221925_.getZ() + $$13, 0.0, 0.0, 0.0);
    }

    @Override
    public void animateTick(BlockState p_221932_, Level p_221933_, BlockPos p_221934_, RandomSource p_221935_) {
        int $$4 = p_221932_.getValue(POWER);
        if ($$4 == 0) {
            return;
        }
        block4: for (Direction $$5 : Direction.Plane.HORIZONTAL) {
            RedstoneSide $$6 = (RedstoneSide)p_221932_.getValue(PROPERTY_BY_DIRECTION.get($$5));
            switch ($$6) {
                case UP: {
                    this.spawnParticlesAlongLine(p_221933_, p_221935_, p_221934_, COLORS[$$4], $$5, Direction.UP, -0.5f, 0.5f);
                }
                case SIDE: {
                    this.spawnParticlesAlongLine(p_221933_, p_221935_, p_221934_, COLORS[$$4], Direction.DOWN, $$5, 0.0f, 0.5f);
                    continue block4;
                }
            }
            this.spawnParticlesAlongLine(p_221933_, p_221935_, p_221934_, COLORS[$$4], Direction.DOWN, $$5, 0.0f, 0.3f);
        }
    }

    @Override
    protected BlockState rotate(BlockState p_55592_, Rotation p_55593_) {
        switch (p_55593_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_55592_.setValue(NORTH, p_55592_.getValue(SOUTH))).setValue(EAST, p_55592_.getValue(WEST))).setValue(SOUTH, p_55592_.getValue(NORTH))).setValue(WEST, p_55592_.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_55592_.setValue(NORTH, p_55592_.getValue(EAST))).setValue(EAST, p_55592_.getValue(SOUTH))).setValue(SOUTH, p_55592_.getValue(WEST))).setValue(WEST, p_55592_.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_55592_.setValue(NORTH, p_55592_.getValue(WEST))).setValue(EAST, p_55592_.getValue(NORTH))).setValue(SOUTH, p_55592_.getValue(EAST))).setValue(WEST, p_55592_.getValue(SOUTH));
            }
        }
        return p_55592_;
    }

    @Override
    protected BlockState mirror(BlockState p_55589_, Mirror p_55590_) {
        switch (p_55590_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_55589_.setValue(NORTH, p_55589_.getValue(SOUTH))).setValue(SOUTH, p_55589_.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_55589_.setValue(EAST, p_55589_.getValue(WEST))).setValue(WEST, p_55589_.getValue(EAST));
            }
        }
        return super.mirror(p_55589_, p_55590_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55605_) {
        p_55605_.add(NORTH, EAST, SOUTH, WEST, POWER);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_55554_, Level p_55555_, BlockPos p_55556_, Player p_55557_, BlockHitResult p_55559_) {
        if (!p_55557_.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        if (RedStoneWireBlock.isCross(p_55554_) || RedStoneWireBlock.isDot(p_55554_)) {
            BlockState $$5 = RedStoneWireBlock.isCross(p_55554_) ? this.defaultBlockState() : this.crossState;
            $$5 = (BlockState)$$5.setValue(POWER, p_55554_.getValue(POWER));
            if (($$5 = this.getConnectionState(p_55555_, $$5, p_55556_)) != p_55554_) {
                p_55555_.setBlock(p_55556_, $$5, 3);
                this.updatesOnShapeChange(p_55555_, p_55556_, p_55554_, $$5);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updatesOnShapeChange(Level p_55535_, BlockPos p_55536_, BlockState p_55537_, BlockState p_55538_) {
        for (Direction $$4 : Direction.Plane.HORIZONTAL) {
            BlockPos $$5 = p_55536_.relative($$4);
            if (((RedstoneSide)p_55537_.getValue(PROPERTY_BY_DIRECTION.get($$4))).isConnected() == ((RedstoneSide)p_55538_.getValue(PROPERTY_BY_DIRECTION.get($$4))).isConnected() || !p_55535_.getBlockState($$5).isRedstoneConductor(p_55535_, $$5)) continue;
            p_55535_.updateNeighborsAtExceptFromFacing($$5, p_55538_.getBlock(), $$4.getOpposite());
        }
    }
}

