/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PistonBaseBlock
extends DirectionalBlock {
    public static final MapCodec<PistonBaseBlock> CODEC = RecordCodecBuilder.mapCodec(p_308861_ -> p_308861_.group((App)Codec.BOOL.fieldOf("sticky").forGetter(p_304492_ -> p_304492_.isSticky), PistonBaseBlock.propertiesCodec()).apply((Applicative)p_308861_, PistonBaseBlock::new));
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;
    public static final int TRIGGER_EXTEND = 0;
    public static final int TRIGGER_CONTRACT = 1;
    public static final int TRIGGER_DROP = 2;
    public static final float PLATFORM_THICKNESS = 4.0f;
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape WEST_AABB = Block.box(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape UP_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape DOWN_AABB = Block.box(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean isSticky;

    public MapCodec<PistonBaseBlock> codec() {
        return CODEC;
    }

    public PistonBaseBlock(boolean p_60163_, BlockBehaviour.Properties p_60164_) {
        super(p_60164_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(EXTENDED, false));
        this.isSticky = p_60163_;
    }

    @Override
    protected VoxelShape getShape(BlockState p_60220_, BlockGetter p_60221_, BlockPos p_60222_, CollisionContext p_60223_) {
        if (p_60220_.getValue(EXTENDED).booleanValue()) {
            switch (p_60220_.getValue(FACING)) {
                case DOWN: {
                    return DOWN_AABB;
                }
                default: {
                    return UP_AABB;
                }
                case NORTH: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case EAST: 
            }
            return EAST_AABB;
        }
        return Shapes.block();
    }

    @Override
    public void setPlacedBy(Level p_60172_, BlockPos p_60173_, BlockState p_60174_, LivingEntity p_60175_, ItemStack p_60176_) {
        if (!p_60172_.isClientSide) {
            this.checkIfExtend(p_60172_, p_60173_, p_60174_);
        }
    }

    @Override
    protected void neighborChanged(BlockState p_60198_, Level p_60199_, BlockPos p_60200_, Block p_60201_, BlockPos p_60202_, boolean p_60203_) {
        if (!p_60199_.isClientSide) {
            this.checkIfExtend(p_60199_, p_60200_, p_60198_);
        }
    }

    @Override
    protected void onPlace(BlockState p_60225_, Level p_60226_, BlockPos p_60227_, BlockState p_60228_, boolean p_60229_) {
        if (p_60228_.is(p_60225_.getBlock())) {
            return;
        }
        if (!p_60226_.isClientSide && p_60226_.getBlockEntity(p_60227_) == null) {
            this.checkIfExtend(p_60226_, p_60227_, p_60225_);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_60166_) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, p_60166_.getNearestLookingDirection().getOpposite())).setValue(EXTENDED, false);
    }

    private void checkIfExtend(Level p_60168_, BlockPos p_60169_, BlockState p_60170_) {
        Direction $$3 = p_60170_.getValue(FACING);
        boolean $$4 = this.getNeighborSignal(p_60168_, p_60169_, $$3);
        if ($$4 && !p_60170_.getValue(EXTENDED).booleanValue()) {
            if (new PistonStructureResolver(p_60168_, p_60169_, $$3, true).resolve()) {
                p_60168_.blockEvent(p_60169_, this, 0, $$3.get3DDataValue());
            }
        } else if (!$$4 && p_60170_.getValue(EXTENDED).booleanValue()) {
            PistonMovingBlockEntity $$9;
            BlockEntity $$8;
            BlockPos $$5 = p_60169_.relative($$3, 2);
            BlockState $$6 = p_60168_.getBlockState($$5);
            int $$7 = 1;
            if ($$6.is(Blocks.MOVING_PISTON) && $$6.getValue(FACING) == $$3 && ($$8 = p_60168_.getBlockEntity($$5)) instanceof PistonMovingBlockEntity && ($$9 = (PistonMovingBlockEntity)$$8).isExtending() && ($$9.getProgress(0.0f) < 0.5f || p_60168_.getGameTime() == $$9.getLastTicked() || ((ServerLevel)p_60168_).isHandlingTick())) {
                $$7 = 2;
            }
            p_60168_.blockEvent(p_60169_, this, $$7, $$3.get3DDataValue());
        }
    }

    private boolean getNeighborSignal(SignalGetter p_277378_, BlockPos p_60179_, Direction p_60180_) {
        for (Direction $$3 : Direction.values()) {
            if ($$3 == p_60180_ || !p_277378_.hasSignal(p_60179_.relative($$3), $$3)) continue;
            return true;
        }
        if (p_277378_.hasSignal(p_60179_, Direction.DOWN)) {
            return true;
        }
        BlockPos $$4 = p_60179_.above();
        for (Direction $$5 : Direction.values()) {
            if ($$5 == Direction.DOWN || !p_277378_.hasSignal($$4.relative($$5), $$5)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean triggerEvent(BlockState p_60192_, Level p_60193_, BlockPos p_60194_, int p_60195_, int p_60196_) {
        Direction $$5 = p_60192_.getValue(FACING);
        BlockState $$6 = (BlockState)p_60192_.setValue(EXTENDED, true);
        if (!p_60193_.isClientSide) {
            boolean $$7 = this.getNeighborSignal(p_60193_, p_60194_, $$5);
            if ($$7 && (p_60195_ == 1 || p_60195_ == 2)) {
                p_60193_.setBlock(p_60194_, $$6, 2);
                return false;
            }
            if (!$$7 && p_60195_ == 0) {
                return false;
            }
        }
        if (p_60195_ == 0) {
            if (!this.moveBlocks(p_60193_, p_60194_, $$5, true)) return false;
            p_60193_.setBlock(p_60194_, $$6, 67);
            p_60193_.playSound(null, p_60194_, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, p_60193_.random.nextFloat() * 0.25f + 0.6f);
            p_60193_.gameEvent(GameEvent.BLOCK_ACTIVATE, p_60194_, GameEvent.Context.of($$6));
            return true;
        } else {
            if (p_60195_ != 1 && p_60195_ != 2) return true;
            BlockEntity $$8 = p_60193_.getBlockEntity(p_60194_.relative($$5));
            if ($$8 instanceof PistonMovingBlockEntity) {
                ((PistonMovingBlockEntity)$$8).finalTick();
            }
            BlockState $$9 = (BlockState)((BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(MovingPistonBlock.FACING, $$5)).setValue(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            p_60193_.setBlock(p_60194_, $$9, 20);
            p_60193_.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(p_60194_, $$9, (BlockState)this.defaultBlockState().setValue(FACING, Direction.from3DDataValue(p_60196_ & 7)), $$5, false, true));
            p_60193_.blockUpdated(p_60194_, $$9.getBlock());
            $$9.updateNeighbourShapes(p_60193_, p_60194_, 2);
            if (this.isSticky) {
                PistonMovingBlockEntity $$14;
                BlockEntity $$13;
                BlockPos $$10 = p_60194_.offset($$5.getStepX() * 2, $$5.getStepY() * 2, $$5.getStepZ() * 2);
                BlockState $$11 = p_60193_.getBlockState($$10);
                boolean $$12 = false;
                if ($$11.is(Blocks.MOVING_PISTON) && ($$13 = p_60193_.getBlockEntity($$10)) instanceof PistonMovingBlockEntity && ($$14 = (PistonMovingBlockEntity)$$13).getDirection() == $$5 && $$14.isExtending()) {
                    $$14.finalTick();
                    $$12 = true;
                }
                if (!$$12) {
                    if (p_60195_ == 1 && !$$11.isAir() && PistonBaseBlock.isPushable($$11, p_60193_, $$10, $$5.getOpposite(), false, $$5) && ($$11.getPistonPushReaction() == PushReaction.NORMAL || $$11.is(Blocks.PISTON) || $$11.is(Blocks.STICKY_PISTON))) {
                        this.moveBlocks(p_60193_, p_60194_, $$5, false);
                    } else {
                        p_60193_.removeBlock(p_60194_.relative($$5), false);
                    }
                }
            } else {
                p_60193_.removeBlock(p_60194_.relative($$5), false);
            }
            p_60193_.playSound(null, p_60194_, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, p_60193_.random.nextFloat() * 0.15f + 0.6f);
            p_60193_.gameEvent(GameEvent.BLOCK_DEACTIVATE, p_60194_, GameEvent.Context.of($$9));
        }
        return true;
    }

    public static boolean isPushable(BlockState p_60205_, Level p_60206_, BlockPos p_60207_, Direction p_60208_, boolean p_60209_, Direction p_60210_) {
        if (p_60207_.getY() < p_60206_.getMinBuildHeight() || p_60207_.getY() > p_60206_.getMaxBuildHeight() - 1 || !p_60206_.getWorldBorder().isWithinBounds(p_60207_)) {
            return false;
        }
        if (p_60205_.isAir()) {
            return true;
        }
        if (p_60205_.is(Blocks.OBSIDIAN) || p_60205_.is(Blocks.CRYING_OBSIDIAN) || p_60205_.is(Blocks.RESPAWN_ANCHOR) || p_60205_.is(Blocks.REINFORCED_DEEPSLATE)) {
            return false;
        }
        if (p_60208_ == Direction.DOWN && p_60207_.getY() == p_60206_.getMinBuildHeight()) {
            return false;
        }
        if (p_60208_ == Direction.UP && p_60207_.getY() == p_60206_.getMaxBuildHeight() - 1) {
            return false;
        }
        if (p_60205_.is(Blocks.PISTON) || p_60205_.is(Blocks.STICKY_PISTON)) {
            if (p_60205_.getValue(EXTENDED).booleanValue()) {
                return false;
            }
        } else {
            if (p_60205_.getDestroySpeed(p_60206_, p_60207_) == -1.0f) {
                return false;
            }
            switch (p_60205_.getPistonPushReaction()) {
                case BLOCK: {
                    return false;
                }
                case DESTROY: {
                    return p_60209_;
                }
                case PUSH_ONLY: {
                    return p_60208_ == p_60210_;
                }
            }
        }
        return !p_60205_.hasBlockEntity();
    }

    private boolean moveBlocks(Level p_60182_, BlockPos p_60183_, Direction p_60184_, boolean p_60185_) {
        PistonStructureResolver $$5;
        BlockPos $$4 = p_60183_.relative(p_60184_);
        if (!p_60185_ && p_60182_.getBlockState($$4).is(Blocks.PISTON_HEAD)) {
            p_60182_.setBlock($$4, Blocks.AIR.defaultBlockState(), 20);
        }
        if (!($$5 = new PistonStructureResolver(p_60182_, p_60183_, p_60184_, p_60185_)).resolve()) {
            return false;
        }
        HashMap $$6 = Maps.newHashMap();
        List<BlockPos> $$7 = $$5.getToPush();
        ArrayList $$8 = Lists.newArrayList();
        for (BlockPos $$9 : $$7) {
            BlockState $$10 = p_60182_.getBlockState($$9);
            $$8.add($$10);
            $$6.put($$9, $$10);
        }
        List<BlockPos> $$11 = $$5.getToDestroy();
        BlockState[] $$12 = new BlockState[$$7.size() + $$11.size()];
        Direction $$13 = p_60185_ ? p_60184_ : p_60184_.getOpposite();
        int $$14 = 0;
        for (int $$15 = $$11.size() - 1; $$15 >= 0; --$$15) {
            BlockPos $$16 = $$11.get($$15);
            BlockState blockState = p_60182_.getBlockState($$16);
            BlockEntity $$18 = blockState.hasBlockEntity() ? p_60182_.getBlockEntity($$16) : null;
            PistonBaseBlock.dropResources(blockState, p_60182_, $$16, $$18);
            p_60182_.setBlock($$16, Blocks.AIR.defaultBlockState(), 18);
            p_60182_.gameEvent(GameEvent.BLOCK_DESTROY, $$16, GameEvent.Context.of(blockState));
            if (!blockState.is(BlockTags.FIRE)) {
                p_60182_.addDestroyBlockEffect($$16, blockState);
            }
            $$12[$$14++] = blockState;
        }
        for (int $$19 = $$7.size() - 1; $$19 >= 0; --$$19) {
            BlockPos $$20 = $$7.get($$19);
            BlockState blockState = p_60182_.getBlockState($$20);
            $$20 = $$20.relative($$13);
            $$6.remove($$20);
            BlockState $$22 = (BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(FACING, p_60184_);
            p_60182_.setBlock($$20, $$22, 68);
            p_60182_.setBlockEntity(MovingPistonBlock.newMovingBlockEntity($$20, $$22, (BlockState)$$8.get($$19), p_60184_, p_60185_, false));
            $$12[$$14++] = blockState;
        }
        if (p_60185_) {
            PistonType $$23 = this.isSticky ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState $$24 = (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(PistonHeadBlock.FACING, p_60184_)).setValue(PistonHeadBlock.TYPE, $$23);
            BlockState blockState = (BlockState)((BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(MovingPistonBlock.FACING, p_60184_)).setValue(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            $$6.remove($$4);
            p_60182_.setBlock($$4, blockState, 68);
            p_60182_.setBlockEntity(MovingPistonBlock.newMovingBlockEntity($$4, blockState, $$24, p_60184_, true, true));
        }
        BlockState $$26 = Blocks.AIR.defaultBlockState();
        for (BlockPos blockPos : $$6.keySet()) {
            p_60182_.setBlock(blockPos, $$26, 82);
        }
        for (Map.Entry entry : $$6.entrySet()) {
            BlockPos $$29 = (BlockPos)entry.getKey();
            BlockState $$30 = (BlockState)entry.getValue();
            $$30.updateIndirectNeighbourShapes(p_60182_, $$29, 2);
            $$26.updateNeighbourShapes(p_60182_, $$29, 2);
            $$26.updateIndirectNeighbourShapes(p_60182_, $$29, 2);
        }
        $$14 = 0;
        for (int $$31 = $$11.size() - 1; $$31 >= 0; --$$31) {
            BlockState blockState = $$12[$$14++];
            BlockPos $$33 = $$11.get($$31);
            blockState.updateIndirectNeighbourShapes(p_60182_, $$33, 2);
            p_60182_.updateNeighborsAt($$33, blockState.getBlock());
        }
        for (int $$34 = $$7.size() - 1; $$34 >= 0; --$$34) {
            p_60182_.updateNeighborsAt($$7.get($$34), $$12[$$14++].getBlock());
        }
        if (p_60185_) {
            p_60182_.updateNeighborsAt($$4, Blocks.PISTON_HEAD);
        }
        return true;
    }

    @Override
    protected BlockState rotate(BlockState p_60215_, Rotation p_60216_) {
        return (BlockState)p_60215_.setValue(FACING, p_60216_.rotate(p_60215_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_60212_, Mirror p_60213_) {
        return p_60212_.rotate(p_60213_.getRotation(p_60212_.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_60218_) {
        p_60218_.add(FACING, EXTENDED);
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState p_60231_) {
        return p_60231_.getValue(EXTENDED);
    }

    @Override
    protected boolean isPathfindable(BlockState p_60187_, PathComputationType p_60190_) {
        return false;
    }
}

