/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class AlterGroundDecorator
extends TreeDecorator {
    public static final MapCodec<AlterGroundDecorator> CODEC = BlockStateProvider.CODEC.fieldOf("provider").xmap(AlterGroundDecorator::new, p_69327_ -> p_69327_.provider);
    private final BlockStateProvider provider;

    public AlterGroundDecorator(BlockStateProvider p_69306_) {
        this.provider = p_69306_;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.ALTER_GROUND;
    }

    @Override
    public void place(TreeDecorator.Context p_225969_) {
        ArrayList $$1 = Lists.newArrayList();
        ObjectArrayList<BlockPos> $$2 = p_225969_.roots();
        ObjectArrayList<BlockPos> $$3 = p_225969_.logs();
        if ($$2.isEmpty()) {
            $$1.addAll($$3);
        } else if (!$$3.isEmpty() && ((BlockPos)$$2.get(0)).getY() == ((BlockPos)$$3.get(0)).getY()) {
            $$1.addAll($$3);
            $$1.addAll($$2);
        } else {
            $$1.addAll($$2);
        }
        if ($$1.isEmpty()) {
            return;
        }
        int $$4 = ((BlockPos)$$1.get(0)).getY();
        $$1.stream().filter(p_69310_ -> p_69310_.getY() == $$4).forEach(p_225978_ -> {
            this.placeCircle(p_225969_, p_225978_.west().north());
            this.placeCircle(p_225969_, p_225978_.east(2).north());
            this.placeCircle(p_225969_, p_225978_.west().south(2));
            this.placeCircle(p_225969_, p_225978_.east(2).south(2));
            for (int $$2 = 0; $$2 < 5; ++$$2) {
                int $$3 = p_225969_.random().nextInt(64);
                int $$4 = $$3 % 8;
                int $$5 = $$3 / 8;
                if ($$4 != 0 && $$4 != 7 && $$5 != 0 && $$5 != 7) continue;
                this.placeCircle(p_225969_, p_225978_.offset(-3 + $$4, 0, -3 + $$5));
            }
        });
    }

    private void placeCircle(TreeDecorator.Context p_225971_, BlockPos p_225972_) {
        for (int $$2 = -2; $$2 <= 2; ++$$2) {
            for (int $$3 = -2; $$3 <= 2; ++$$3) {
                if (Math.abs($$2) == 2 && Math.abs($$3) == 2) continue;
                this.placeBlockAt(p_225971_, p_225972_.offset($$2, 0, $$3));
            }
        }
    }

    private void placeBlockAt(TreeDecorator.Context p_225974_, BlockPos p_225975_) {
        for (int $$2 = 2; $$2 >= -3; --$$2) {
            BlockPos $$3 = p_225975_.above($$2);
            if (Feature.isGrassOrDirt(p_225974_.level(), $$3)) {
                p_225974_.setBlock($$3, this.provider.getState(p_225974_.random(), p_225975_));
                break;
            }
            if (!p_225974_.isAir($$3) && $$2 < 0) break;
        }
    }
}

