/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.i18n;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import net.neoforged.fml.i18n.FMLTranslations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMLTranslations.class);
    private static final Gson GSON = new Gson();
    private static final String DEFAULT_LOCALE = "en_us";
    static final Map<String, String> DEFAULT_TRANSLATIONS = Collections.unmodifiableMap(I18nManager.loadTranslations("en_us"));
    static Map<String, String> currentLocale = DEFAULT_TRANSLATIONS;

    public static void injectTranslations(Map<String, String> translations) {
        currentLocale = Collections.unmodifiableMap(translations);
    }

    public static Map<String, String> loadTranslations(String language) {
        InputStream stream = FMLTranslations.class.getResourceAsStream("/lang/" + language + ".json");
        if (stream != null) {
            Map map;
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            try {
                map = (Map)GSON.fromJson((Reader)reader, (TypeToken)new TypeToken<Map<String, String>>(){});
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load translations for locale {}", (Object)language, (Object)e);
                    return Map.of();
                }
            }
            reader.close();
            return map;
        }
        return Map.of();
    }
}

