/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.pathfinder.Path;

public class VillagerMakeLove
extends Behavior<Villager> {
    private long birthTimestamp;

    public VillagerMakeLove() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT), 350, 350);
    }

    protected boolean checkExtraStartConditions(ServerLevel p_24623_, Villager p_24624_) {
        return this.isBreedingPossible(p_24624_);
    }

    protected boolean canStillUse(ServerLevel p_24626_, Villager p_24627_, long p_24628_) {
        return p_24628_ <= this.birthTimestamp && this.isBreedingPossible(p_24627_);
    }

    protected void start(ServerLevel p_24652_, Villager p_24653_, long p_24654_) {
        AgeableMob ageablemob = (AgeableMob)p_24653_.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        BehaviorUtils.lockGazeAndWalkToEachOther((LivingEntity)((Object)p_24653_), (LivingEntity)ageablemob, (float)0.5f, (int)2);
        p_24652_.broadcastEntityEvent((Entity)ageablemob, (byte)18);
        p_24652_.broadcastEntityEvent((Entity)((Object)p_24653_), (byte)18);
        int i = 275 + p_24653_.getRandom().nextInt(50);
        this.birthTimestamp = p_24654_ + (long)i;
    }

    protected void tick(ServerLevel p_24667_, Villager p_24668_, long p_24669_) {
        Villager villager = (Villager)((Object)p_24668_.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get());
        if (!(p_24668_.distanceToSqr((Entity)((Object)villager)) > 5.0)) {
            BehaviorUtils.lockGazeAndWalkToEachOther((LivingEntity)((Object)p_24668_), (LivingEntity)((Object)villager), (float)0.5f, (int)2);
            if (p_24669_ >= this.birthTimestamp) {
                p_24668_.eatAndDigestFood();
                villager.eatAndDigestFood();
                this.tryToGiveBirth(p_24667_, p_24668_, villager);
            } else if (p_24668_.getRandom().nextInt(35) == 0) {
                p_24667_.broadcastEntityEvent((Entity)((Object)villager), (byte)12);
                p_24667_.broadcastEntityEvent((Entity)((Object)p_24668_), (byte)12);
            }
        }
    }

    private void tryToGiveBirth(ServerLevel p_24630_, Villager p_24631_, Villager p_24632_) {
        Optional<BlockPos> optional = this.takeVacantBed(p_24630_, p_24631_);
        if (optional.isEmpty()) {
            p_24630_.broadcastEntityEvent((Entity)((Object)p_24632_), (byte)13);
            p_24630_.broadcastEntityEvent((Entity)((Object)p_24631_), (byte)13);
        } else {
            Optional<Villager> optional1 = this.breed(p_24630_, p_24631_, p_24632_);
            if (optional1.isPresent()) {
                this.giveBedToChild(p_24630_, optional1.get(), optional.get());
            } else {
                p_24630_.getPoiManager().release(optional.get());
                DebugPackets.sendPoiTicketCountPacket((ServerLevel)p_24630_, (BlockPos)optional.get());
            }
        }
    }

    protected void stop(ServerLevel p_24675_, Villager p_24676_, long p_24677_) {
        p_24676_.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
    }

    private boolean isBreedingPossible(Villager p_24640_) {
        Brain<Villager> brain = p_24640_.getBrain();
        Optional<AgeableMob> optional = brain.getMemory(MemoryModuleType.BREED_TARGET).filter(p_348244_ -> p_348244_.getType() == EntityType.VILLAGER);
        return optional.isEmpty() ? false : BehaviorUtils.targetIsValid(brain, (MemoryModuleType)MemoryModuleType.BREED_TARGET, EntityType.VILLAGER) && p_24640_.canBreed() && optional.get().canBreed();
    }

    private Optional<BlockPos> takeVacantBed(ServerLevel p_24649_, Villager p_24650_) {
        return p_24649_.getPoiManager().take(p_217509_ -> p_217509_.is(PoiTypes.HOME), (p_217506_, p_217507_) -> this.canReach(p_24650_, (BlockPos)p_217507_, (Holder<PoiType>)p_217506_), p_24650_.blockPosition(), 48);
    }

    private boolean canReach(Villager p_217501_, BlockPos p_217502_, Holder<PoiType> p_217503_) {
        Path path = p_217501_.getNavigation().createPath(p_217502_, p_217503_.value().validRange());
        return path != null && path.canReach();
    }

    private Optional<Villager> breed(ServerLevel p_24656_, Villager p_24657_, Villager p_24658_) {
        Villager villager = p_24657_.getBreedOffspring(p_24656_, p_24658_);
        if (villager == null) {
            return Optional.empty();
        }
        p_24657_.setAge(6000);
        p_24658_.setAge(6000);
        villager.setAge(-24000);
        villager.moveTo(p_24657_.getX(), p_24657_.getY(), p_24657_.getZ(), 0.0f, 0.0f);
        p_24656_.addFreshEntityWithPassengers((Entity)((Object)villager));
        if (!villager.isAddedToLevel()) {
            return Optional.empty();
        }
        p_24656_.broadcastEntityEvent((Entity)((Object)villager), (byte)12);
        return Optional.of(villager);
    }

    private void giveBedToChild(ServerLevel p_24634_, Villager p_24635_, BlockPos p_24636_) {
        GlobalPos globalpos = GlobalPos.of(p_24634_.dimension(), (BlockPos)p_24636_);
        p_24635_.getBrain().setMemory(MemoryModuleType.HOME, (Object)globalpos);
    }
}

