/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.client.widgets;

import appeng.client.gui.Icon;
import appeng.client.gui.widgets.IconButton;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.pedroksl.ae2addonlib.client.widgets.AddonActionItems;
import net.pedroksl.ae2addonlib.client.widgets.IActionEnum;
import net.pedroksl.ae2addonlib.datagen.LibText;
import org.jetbrains.annotations.Nullable;

public class AddonActionButton
extends IconButton {
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\\n", 16);
    protected final Icon icon;

    public AddonActionButton(IActionEnum action, Runnable onPress) {
        this(action, (Button a) -> onPress.run());
    }

    public AddonActionButton(IActionEnum action, Consumer<Button> onPress) {
        Component displayValue;
        Component displayName;
        block6: {
            block5: {
                super(onPress::accept);
                if (!(action instanceof AddonActionItems)) break block5;
                AddonActionItems item = (AddonActionItems)action;
                switch (item) {
                    case FLUID_FLUSH: {
                        this.icon = Icon.S_CLEAR;
                        displayName = LibText.ClearButton.text();
                        displayValue = LibText.ClearFluidButtonHint.text();
                        break block6;
                    }
                    case CLEAR: {
                        this.icon = Icon.S_CLEAR;
                        displayName = LibText.ClearButton.text();
                        displayValue = LibText.ClearSidesButtonHint.text();
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown ActionItem: " + String.valueOf(action));
                    }
                }
            }
            Appearance app = this.getAppearance(action);
            if (app == null) {
                throw new IllegalArgumentException("Unknown ActionItem: " + String.valueOf(action));
            }
            this.icon = app.icon;
            displayName = app.title;
            displayValue = app.hint;
        }
        this.setMessage(this.buildMessage(displayName, displayValue));
    }

    @Nullable
    protected Appearance getAppearance(IActionEnum action) {
        return null;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    private Component buildMessage(Component displayName, @Nullable Component displayValue) {
        String name = displayName.getString();
        if (displayValue == null) {
            return Component.literal((String)name);
        }
        String value = displayValue.getString();
        StringBuilder sb = new StringBuilder(value = PATTERN_NEW_LINE.matcher(value).replaceAll("\n"));
        int i = sb.lastIndexOf("\n");
        if (i <= 0) {
            i = 0;
        }
        while (i + 30 < sb.length() && (i = sb.lastIndexOf(" ", i + 30)) != -1) {
            sb.replace(i, i + 1, "\n");
        }
        return Component.literal((String)(name + "\n" + String.valueOf(sb)));
    }

    public record Appearance(Icon icon, Component title, Component hint) {
    }
}

