/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.client.widgets;

import appeng.client.gui.widgets.ITooltip;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.pedroksl.ae2addonlib.client.widgets.AddonIconButton;
import net.pedroksl.ae2addonlib.client.widgets.IBlitterIcon;

public class AddonToggleButton
extends AddonIconButton
implements ITooltip {
    private final Listener listener;
    private final IBlitterIcon iconOn;
    private final IBlitterIcon iconOff;
    private List<Component> tooltipOn = Collections.emptyList();
    private List<Component> tooltipOff = Collections.emptyList();
    private boolean state;

    public AddonToggleButton(IBlitterIcon on, IBlitterIcon off, Component displayName, Component displayHint, Listener listener) {
        this(on, off, listener);
        this.setTooltipOn(List.of(displayName, displayHint));
        this.setTooltipOff(List.of(displayName, displayHint));
    }

    public AddonToggleButton(IBlitterIcon on, IBlitterIcon off, Component displayName, Component displayHintOn, Component displayHintOff, Listener listener) {
        this(on, off, listener);
        this.setTooltipOn(List.of(displayName, displayHintOn));
        this.setTooltipOff(List.of(displayName, displayHintOff));
    }

    public AddonToggleButton(IBlitterIcon on, IBlitterIcon off, Listener listener) {
        super(null);
        this.iconOn = on;
        this.iconOff = off;
        this.listener = listener;
    }

    public void setTooltipOn(List<Component> lines) {
        this.tooltipOn = lines;
    }

    public void setTooltipOff(List<Component> lines) {
        this.tooltipOff = lines;
    }

    public void onPress() {
        this.listener.onChange(!this.state);
    }

    public void setState(boolean isOn) {
        this.state = isOn;
    }

    @Override
    protected IBlitterIcon getIcon() {
        return this.state ? this.iconOn : this.iconOff;
    }

    @Override
    public List<Component> getTooltipMessage() {
        return this.state ? this.tooltipOn : this.tooltipOff;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return super.isTooltipAreaVisible() && !this.getTooltipMessage().isEmpty();
    }

    @FunctionalInterface
    public static interface Listener {
        public void onChange(boolean var1);
    }
}

