/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.datagen;

import guideme.internal.data.LocalizationEnum;

public enum LibText implements LocalizationEnum
{
    ClearButton("Clear", Type.TOOLTIP),
    ClearFluidButtonHint("Flush the remaining fluid from the machine.", Type.TOOLTIP),
    ClearSidesButtonHint("Disable output from all sides of the machine.", Type.TOOLTIP),
    DirectionalOutput("Directional Output", Type.TOOLTIP),
    DirectionalOutputHint("Configure which directions are allowed for output auto-export", Type.TOOLTIP),
    Enabled("Enabled", Type.TOOLTIP),
    Disabled("Disabled", Type.TOOLTIP),
    TankEmpty("Empty", Type.TOOLTIP),
    TankAmount("%s / %s B", Type.TOOLTIP),
    SetAmount("Set Amount", Type.GUI),
    InvalidHexInput("Invalid hex code input", Type.TOOLTIP);

    private final String englishText;
    private final Type type;

    private LibText(String englishText, Type type) {
        this.englishText = englishText;
        this.type = type;
    }

    public String getEnglishText() {
        return this.englishText;
    }

    public String getTranslationKey() {
        return String.format("%s.%s.%s", this.type.root, "ae2addonlib", this.name());
    }

    private static enum Type {
        GUI("gui"),
        TOOLTIP("gui.tooltips"),
        EMI_CATEGORY("emi.category"),
        EMI_TEXT("emi.text");

        private final String root;

        private Type(String root) {
            this.root = root;
        }
    }
}

