/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.registry;

import appeng.core.definitions.ItemDefinition;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.pedroksl.ae2addonlib.registry.helpers.FluidDefinition;
import org.slf4j.Logger;

public class FluidRegistry {
    private static final Logger LOG = LogUtils.getLogger();
    private static final Map<String, DeferredRegister<FluidType>> DR_FLUID_TYPES = new HashMap<String, DeferredRegister<FluidType>>();
    private static final Map<String, DeferredRegister<Fluid>> DR_FLUIDS = new HashMap<String, DeferredRegister<Fluid>>();
    private static final Map<String, DeferredRegister.Blocks> DR_FLUID_BLOCKS = new HashMap<String, DeferredRegister.Blocks>();
    private static final Map<String, DeferredRegister.Items> DR_BUCKET_ITEMS = new HashMap<String, DeferredRegister.Items>();
    private static final Map<String, List<FluidDefinition<?, ?>>> FLUIDS = new HashMap();
    private final String modId;

    public FluidRegistry(String modId) {
        if (DR_FLUID_TYPES.containsKey(modId) && FMLEnvironment.dist.isClient()) {
            LOG.error("Tried to initialize FluidRegistry on Client Dist with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        this.modId = modId;
        DR_FLUID_TYPES.put(modId, (DeferredRegister<FluidType>)DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)modId));
        DR_FLUIDS.put(modId, (DeferredRegister<Fluid>)DeferredRegister.create((ResourceKey)Registries.FLUID, (String)modId));
        DR_FLUID_BLOCKS.put(modId, DeferredRegister.createBlocks((String)modId));
        DR_BUCKET_ITEMS.put(modId, DeferredRegister.createItems((String)modId));
        FLUIDS.put(modId, new ArrayList());
    }

    public List<FluidDefinition<?, ?>> getFluids() {
        return FluidRegistry.getFluids(this.modId);
    }

    public static List<FluidDefinition<?, ?>> getFluids(String modId) {
        return Collections.unmodifiableList(FLUIDS.getOrDefault(modId, new ArrayList()));
    }

    protected static <F extends Fluid, B extends LiquidBlock> FluidDefinition<F, B> fluid(String modId, String englishName, String id, Supplier<FluidType> fluidTypeSupplier, Supplier<F> flowingSupplier, Supplier<F> sourceSupplier, Supplier<B> liquidBlockSupplier) {
        DeferredHolder type = DR_FLUID_TYPES.get(modId).register(id + "_type", fluidTypeSupplier);
        DeferredHolder flowing = DR_FLUIDS.get(modId).register(id + "_flowing", flowingSupplier);
        DeferredHolder source = DR_FLUIDS.get(modId).register(id + "_source", sourceSupplier);
        DeferredBlock block = DR_FLUID_BLOCKS.get(modId).register(id + "_block", liquidBlockSupplier);
        DeferredItem bucketItem = DR_BUCKET_ITEMS.get(modId).register(id + "_bucket", () -> new BucketItem((Fluid)source.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
        ItemDefinition bucketDefinition = new ItemDefinition(englishName + " Bucket", bucketItem);
        FluidDefinition definition = new FluidDefinition(englishName, (DeferredHolder<FluidType, FluidType>)type, flowing, source, block, (ItemDefinition<BucketItem>)bucketDefinition);
        FLUIDS.get(modId).add(definition);
        return definition;
    }

    public void register(IEventBus eventBus) {
        DR_FLUID_TYPES.get(this.modId).register(eventBus);
        DR_FLUIDS.get(this.modId).register(eventBus);
        DR_FLUID_BLOCKS.get(this.modId).register(eventBus);
        DR_BUCKET_ITEMS.get(this.modId).register(eventBus);
    }

    public static int getFluidColor(ItemStack stack, int index) {
        Item item;
        if (index == 1 && (item = stack.getItem()) instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            return IClientFluidTypeExtensions.of((Fluid)bucketItem.content).getTintColor();
        }
        return -1;
    }
}

