/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.registry;

import appeng.menu.AEBaseMenu;
import appeng.menu.implementations.MenuTypeBuilder;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

public abstract class MenuRegistry {
    private static final Logger LOG = LogUtils.getLogger();
    private static final Map<String, DeferredRegister<MenuType<?>>> DRMap = new HashMap();
    private final String modId;

    public MenuRegistry(String modId) {
        if (DRMap.containsKey(modId) && FMLEnvironment.dist.isClient()) {
            LOG.error("Tried to initialize MenuRegistry on Client Dist with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        this.modId = modId;
        DRMap.put(modId, DeferredRegister.create((ResourceKey)Registries.MENU, (String)modId));
    }

    static DeferredRegister<MenuType<?>> getDR(String modId) {
        DeferredRegister dr = DRMap.getOrDefault(modId, null);
        if (dr == null) {
            LOG.error("Tried to access uninitialized deferred register with mod id {}", (Object)modId);
            throw new IllegalStateException();
        }
        return dr;
    }

    protected static <M extends AEBaseMenu, H> Supplier<MenuType<M>> create(String modId, String id, MenuTypeBuilder.MenuFactory<M, H> factory, Class<H> host) {
        return MenuRegistry.getDR(modId).register(id, () -> MenuTypeBuilder.create((MenuTypeBuilder.MenuFactory)factory, (Class)host).build(ResourceLocation.fromNamespaceAndPath((String)modId, (String)id)));
    }

    protected static <T extends AEBaseMenu> Supplier<MenuType<T>> create(String modId, String id, Supplier<MenuType<T>> supplier) {
        return MenuRegistry.getDR(modId).register(id, supplier);
    }

    public void register(IEventBus eventBus) {
        MenuRegistry.getDR(this.modId).register(eventBus);
    }
}

