/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.blockentities;

import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.EnergyDetectorPeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.setup.BlockEntityTypes;
import de.srendi.advancedperipherals.common.util.EnergyStorageProxy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyDetectorEntity
extends PeripheralBlockEntity<EnergyDetectorPeripheral> {
    private final EnergyStorage zeroStorage = new EnergyStorage(0, 0, 0);
    public int transferRate = 0;
    public EnergyStorageProxy storageProxy;
    IEnergyStorage energyStorageCap;
    Direction energyInDirection;
    Direction energyOutDirection;
    IEnergyStorage zeroStorageCap;
    private IEnergyStorage outReceivingStorage;

    public EnergyDetectorEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.ENERGY_DETECTOR.get(), pos, state);
        this.storageProxy = new EnergyStorageProxy(this, (Integer)APConfig.PERIPHERALS_CONFIG.energyDetectorMaxFlow.get());
        this.energyStorageCap = this.storageProxy;
        this.energyInDirection = Direction.NORTH;
        this.energyOutDirection = Direction.SOUTH;
        this.zeroStorageCap = this.zeroStorage;
        this.outReceivingStorage = null;
    }

    @Override
    @NotNull
    protected EnergyDetectorPeripheral createPeripheral() {
        return new EnergyDetectorPeripheral(this);
    }

    @Override
    @Nullable
    public IEnergyStorage createEnergyStorageCap(@Nullable Direction direction) {
        this.energyInDirection = ((FrontAndTop)this.getBlockState().getValue((Property)JigsawBlock.ORIENTATION)).front();
        this.energyOutDirection = ((FrontAndTop)this.getBlockState().getValue((Property)JigsawBlock.ORIENTATION)).front().getOpposite();
        if (direction == this.energyInDirection) {
            return this.energyStorageCap;
        }
        if (direction == this.energyOutDirection) {
            return this.zeroStorageCap;
        }
        return null;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        tag.putInt("transferRate", this.transferRate);
        super.saveAdditional(tag, provider);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        this.transferRate = tag.getInt("transferRate");
        super.loadAdditional(tag, provider);
    }

    @Override
    public <T extends BlockEntity> void handleTick(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.isClientSide) {
            this.transferRate = this.storageProxy.getTransferredInThisTick();
            this.storageProxy.resetTransferedInThisTick();
        }
    }

    public void invalidateStorages() {
        this.outReceivingStorage = null;
    }

    public IEnergyStorage getOutputStorage() {
        if (this.outReceivingStorage == null) {
            BlockEntity teOut = this.level.getBlockEntity(this.worldPosition.relative(this.energyOutDirection));
            if (teOut == null) {
                return null;
            }
            this.outReceivingStorage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.worldPosition.relative(this.energyOutDirection), (Object)this.energyOutDirection.getOpposite());
        }
        return this.outReceivingStorage;
    }
}

