/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.salvaging;

import com.google.common.base.Predicates;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.affix.salvaging.SalvagingTableTile;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.menu.BlockEntityMenu;
import dev.shadowsoffire.placebo.menu.FilteredSlot;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class SalvagingMenu
extends BlockEntityMenu<SalvagingTableTile> {
    protected final Player player;
    protected final InternalItemHandler inputInv = new InternalItemHandler(12);

    public SalvagingMenu(int id, Inventory inv, BlockPos pos) {
        super(Apoth.Menus.SALVAGE, id, inv, pos);
        int i;
        this.player = inv.player;
        int leftOffset = 17;
        int topOffset = 17;
        for (i = 0; i < 12; ++i) {
            this.addSlot((Slot)new PlaceboContainerMenu.UpdatingSlot(this, this.inputInv, i, leftOffset + i % 4 * 19, topOffset + i / 4 * 19, s -> !SalvagingMenu.findMatch(this.level, s).isEmpty()){

                public int getMaxStackSize() {
                    return 1;
                }

                public int getMaxStackSize(ItemStack stack) {
                    return 1;
                }
            });
        }
        for (i = 0; i < 6; ++i) {
            leftOffset = 124;
            topOffset = 17;
            this.addSlot((Slot)new FilteredSlot(((SalvagingTableTile)this.tile).output, i, leftOffset + i % 2 * 19, topOffset + i / 2 * 19, (Predicate)Predicates.alwaysFalse()));
        }
        this.addPlayerSlots(inv, 8, 92);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && !SalvagingMenu.findMatch(this.level, stack).isEmpty(), 0, 12);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
    }

    public boolean stillValid(Player player) {
        if (this.level.isClientSide) {
            return true;
        }
        return this.level.getBlockState(this.pos).is(Apoth.Blocks.SALVAGING_TABLE);
    }

    public void removed(Player player) {
        super.removed(player);
        if (!this.level.isClientSide) {
            this.clearContainer(player, (IItemHandler)this.inputInv);
        }
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == 0) {
            this.salvageAll();
            this.level.playSound(null, player.blockPosition(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.BLOCKS, 0.99f, this.level.random.nextFloat() * 0.25f + 1.0f);
            this.level.playSound(null, player.blockPosition(), SoundEvents.AMETHYST_CLUSTER_STEP, SoundSource.BLOCKS, 0.34f, this.level.random.nextFloat() * 0.2f + 0.8f);
            this.level.playSound(null, player.blockPosition(), SoundEvents.SMITHING_TABLE_USE, SoundSource.BLOCKS, 0.45f, this.level.random.nextFloat() * 0.5f + 0.75f);
            return true;
        }
        return super.clickMenuButton(player, id);
    }

    protected void giveItem(Player player, ItemStack stack) {
        if (!player.isAlive() || player instanceof ServerPlayer && ((ServerPlayer)player).hasDisconnected()) {
            player.drop(stack, false);
        } else {
            Inventory inventory = player.getInventory();
            if (inventory.player instanceof ServerPlayer) {
                inventory.placeItemBackInInventory(stack);
            }
        }
    }

    protected void salvageAll() {
        for (int inSlot = 0; inSlot < 12; ++inSlot) {
            Slot s = this.getSlot(inSlot);
            ItemStack stack = s.getItem();
            List<ItemStack> outputs = SalvagingMenu.getSalvageResults(this.level, stack);
            s.set(ItemStack.EMPTY);
            for (ItemStack out : outputs) {
                for (int outSlot = 0; outSlot < 6 && !out.isEmpty(); ++outSlot) {
                    out = ((SalvagingTableTile)this.tile).output.insertItem(outSlot, out, false);
                }
                if (out.isEmpty()) continue;
                this.giveItem(this.player, out);
            }
        }
    }

    public static int getSalvageCount(SalvagingRecipe.OutputData output, ItemStack stack, RandomSource rand) {
        int[] counts = SalvagingMenu.getSalvageCounts(output, stack);
        return rand.nextInt(counts[0], counts[1] + 1);
    }

    public static int[] getSalvageCounts(SalvagingRecipe.OutputData output, ItemStack stack) {
        int[] out = new int[]{output.min(), output.max()};
        if (stack.isDamageableItem()) {
            int maxDmg = stack.getMaxDamage();
            if (maxDmg <= 0) {
                Apotheosis.LOGGER.warn("Item {} returned true to ItemStack#isDamageableItem, but returned {} from ItemStack#getMaxDamage, when the value should be positive!", (Object)stack.getItemHolder().getKey(), (Object)maxDmg);
                return out;
            }
            out[1] = Math.max(out[0], Math.round(out[1] * (maxDmg - stack.getDamageValue()) / maxDmg));
        }
        return out;
    }

    public static List<ItemStack> getSalvageResults(Level level, ItemStack stack) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (RecipeHolder<SalvagingRecipe> recipe : SalvagingMenu.findMatch(level, stack)) {
            for (SalvagingRecipe.OutputData d : ((SalvagingRecipe)recipe.value()).getOutputs()) {
                ItemStack out = d.stack().copy();
                out.setCount(SalvagingMenu.getSalvageCount(d, stack, level.random));
                outputs.add(out);
            }
        }
        return outputs;
    }

    public static List<ItemStack> getBestPossibleSalvageResults(Level level, ItemStack stack) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (RecipeHolder<SalvagingRecipe> recipe : SalvagingMenu.findMatch(level, stack)) {
            for (SalvagingRecipe.OutputData d : ((SalvagingRecipe)recipe.value()).getOutputs()) {
                ItemStack out = d.stack().copy();
                out.setCount(SalvagingMenu.getSalvageCounts(d, stack)[1]);
                outputs.add(out);
            }
        }
        return outputs;
    }

    public static List<RecipeHolder<SalvagingRecipe>> findMatch(Level level, ItemStack stack) {
        return level.getRecipeManager().getRecipesFor(Apoth.RecipeTypes.SALVAGING, (RecipeInput)new SingleRecipeInput(stack), level);
    }
}

