/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.advancements.EquippedItemTrigger;
import dev.shadowsoffire.apotheosis.advancements.predicates.AffixItemPredicate;
import dev.shadowsoffire.apotheosis.advancements.predicates.InvaderPredicate;
import dev.shadowsoffire.apotheosis.advancements.predicates.RarityItemPredicate;
import dev.shadowsoffire.apotheosis.advancements.predicates.TypeAwareISP;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.advancements.FinishGatewayTrigger;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.item.GatePearlItem;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ApothAdvancementProvider
extends AdvancementProvider {
    private final Map<ResourceLocation, List<ICondition>> conditions = new HashMap<ResourceLocation, List<ICondition>>();

    private ApothAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper, List<AdvancementProvider.AdvancementGenerator> subProviders) {
        super(output, registries, existingFileHelper, subProviders);
    }

    public final CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(regs -> {
            Codec conditionalCodec = ConditionalOps.createConditionalCodecWithConditions((Codec)Advancement.CODEC);
            HashSet set = new HashSet();
            ArrayList list = new ArrayList();
            ConditionalConsumer<AdvancementHolder> consumer = this.wrap(holder -> {
                if (!set.add(holder.id())) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(holder.id()));
                }
                Path path = this.pathProvider.json(holder.id());
                List conds = this.conditions.getOrDefault(holder.id(), List.of());
                if (conds.isEmpty()) {
                    list.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)regs, (Codec)Advancement.CODEC, (Object)holder.value(), (Path)path));
                } else {
                    WithConditions withConds = new WithConditions(conds, (Object)holder.value());
                    list.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)regs, (Codec)conditionalCodec, Optional.of(withConds), (Path)path));
                }
            });
            for (AdvancementSubProvider advancementsubprovider : this.subProviders) {
                advancementsubprovider.generate(regs, consumer);
            }
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    public static ApothAdvancementProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        return new ApothAdvancementProvider(output, registries, existingFileHelper, List.of(new ProgressionGenerator()));
    }

    private static Component title(String key) {
        return Apotheosis.lang("advancements", key + ".title", new Object[0]);
    }

    private static Component desc(String key) {
        return Apotheosis.lang("advancements", key + ".desc", new Object[0]);
    }

    private static String loc(String path) {
        return Apotheosis.loc(path).toString();
    }

    private static ItemPredicate ip(TypeAwareISP<?> sub) {
        return new ItemPredicate(Optional.empty(), MinMaxBounds.Ints.ANY, DataComponentPredicate.EMPTY, Map.of(sub.type(), sub));
    }

    private static DynamicHolder<LootRarity> rarity(String path) {
        return RarityRegistry.INSTANCE.holder(Apotheosis.loc(path));
    }

    private static DynamicHolder<Gateway> gateway(String path) {
        return GatewayRegistry.INSTANCE.holder(Apotheosis.loc(path));
    }

    private static ItemStack gatePearl(DynamicHolder<Gateway> gate) {
        ItemStack stack = new ItemStack(GatewayObjects.GATE_PEARL);
        GatePearlItem.setGate((ItemStack)stack, gate);
        return stack;
    }

    private void addCondition(AdvancementHolder adv, ICondition cond) {
        this.conditions.computeIfAbsent(adv.id(), a -> new ArrayList()).add(cond);
    }

    private <T> ConditionalConsumer<T> wrap(final Consumer<T> consumer) {
        return new ConditionalConsumer<T>(){

            @Override
            public void accept(T t) {
                consumer.accept(t);
            }

            @Override
            public void saveConditionally(T adv, ICondition ... conditions) {
                for (ICondition cond : conditions) {
                    ApothAdvancementProvider.this.addCondition((AdvancementHolder)adv, cond);
                }
                this.accept(adv);
            }
        };
    }

    private static class ProgressionGenerator
    implements AdvancementProvider.AdvancementGenerator {
        private ProgressionGenerator() {
        }

        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
            ConditionalConsumer consumer = (ConditionalConsumer)saver;
            DynamicHolder<LootRarity> common = ApothAdvancementProvider.rarity("common");
            DynamicHolder<LootRarity> uncommon = ApothAdvancementProvider.rarity("uncommon");
            DynamicHolder<LootRarity> rare = ApothAdvancementProvider.rarity("rare");
            DynamicHolder<LootRarity> epic = ApothAdvancementProvider.rarity("epic");
            DynamicHolder<LootRarity> mythic = ApothAdvancementProvider.rarity("mythic");
            AdvancementHolder root = Advancement.Builder.advancement().display((ItemLike)Apoth.Items.BOSS_SUMMONER.value(), ApothAdvancementProvider.title("progression.root"), ApothAdvancementProvider.desc("progression.root"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.TASK, false, false, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("tick", PlayerTrigger.TriggerInstance.tick()).save(saver, ApothAdvancementProvider.loc("progression/root"));
            AdvancementHolder haven = Advancement.Builder.advancement().display((ItemLike)Items.OAK_SAPLING, ApothAdvancementProvider.title("progression.haven"), ApothAdvancementProvider.desc("progression.haven"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("affixed", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ApothAdvancementProvider.ip(new AffixItemPredicate())})).parent(root).save(saver, ApothAdvancementProvider.loc("progression/haven"));
            AdvancementHolder frontier = Advancement.Builder.advancement().display((ItemLike)Items.IRON_SWORD, ApothAdvancementProvider.title("progression.frontier"), ApothAdvancementProvider.desc("progression.frontier"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("common_helm", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HEAD, common, uncommon, rare, epic, mythic)).addCriterion("common_chest", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.CHEST, common, uncommon, rare, epic, mythic)).addCriterion("common_legs", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.LEGS, common, uncommon, rare, epic, mythic)).addCriterion("common_feet", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.FEET, common, uncommon, rare, epic, mythic)).addCriterion("common_hand", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HAND, common, uncommon, rare, epic, mythic)).parent(haven).save(saver, ApothAdvancementProvider.loc("progression/frontier"));
            AdvancementHolder ascent = Advancement.Builder.advancement().display((ItemLike)Items.BLAZE_POWDER, ApothAdvancementProvider.title("progression.ascent"), ApothAdvancementProvider.desc("progression.ascent"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("uncommon_helm", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HEAD, uncommon, rare, epic, mythic)).addCriterion("uncommon_chest", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.CHEST, uncommon, rare, epic, mythic)).addCriterion("uncommon_legs", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.LEGS, uncommon, rare, epic, mythic)).addCriterion("uncommon_feet", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.FEET, uncommon, rare, epic, mythic)).addCriterion("uncommon_hand", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HAND, uncommon, rare, epic, mythic)).addCriterion("kill_apothic_invader", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)InvaderPredicate.INSTANCE))).parent(frontier).save(saver, ApothAdvancementProvider.loc("progression/ascent"));
            AdvancementHolder summit = Advancement.Builder.advancement().display((ItemLike)Items.NETHERITE_SWORD, ApothAdvancementProvider.title("progression.summit"), ApothAdvancementProvider.desc("progression.summit"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("rare_helm", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HEAD, rare, epic, mythic)).addCriterion("rare_chest", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.CHEST, rare, epic, mythic)).addCriterion("rare_legs", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.LEGS, rare, epic, mythic)).addCriterion("rare_feet", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.FEET, rare, epic, mythic)).addCriterion("rare_hand", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HAND, rare, epic, mythic)).addCriterion("kill_wither", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.WITHER))).parent(ascent).save(saver, ApothAdvancementProvider.loc("progression/summit"));
            AdvancementHolder pinnacle = Advancement.Builder.advancement().display((ItemLike)Items.END_CRYSTAL, ApothAdvancementProvider.title("progression.pinnacle"), ApothAdvancementProvider.desc("progression.pinnacle"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.CHALLENGE, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("epic_helm", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HEAD, epic, mythic)).addCriterion("epic_chest", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.CHEST, epic, mythic)).addCriterion("epic_legs", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.LEGS, epic, mythic)).addCriterion("epic_feet", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.FEET, epic, mythic)).addCriterion("epic_hand", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HAND, epic, mythic)).addCriterion("kill_ender_dragon", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.ENDER_DRAGON))).parent(summit).save(saver, ApothAdvancementProvider.loc("progression/pinnacle"));
            DynamicHolder<Gateway> frontierGate = ApothAdvancementProvider.gateway("tiered/frontier");
            DynamicHolder<Gateway> ascentGate = ApothAdvancementProvider.gateway("tiered/ascent");
            DynamicHolder<Gateway> summitGate = ApothAdvancementProvider.gateway("tiered/summit");
            DynamicHolder<Gateway> pinnacleGate = ApothAdvancementProvider.gateway("tiered/pinnacle");
            AdvancementHolder completeFrontierGate = Advancement.Builder.advancement().display(ApothAdvancementProvider.gatePearl(frontierGate), ApothAdvancementProvider.title("challenge_gates.frontier"), ApothAdvancementProvider.desc("challenge_gates.frontier"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("complete_frontier_gate", ProgressionGenerator.completeGateway(frontierGate)).parent(frontier).build(Apotheosis.loc("gateways/frontier"));
            consumer.saveConditionally(completeFrontierGate, new ICondition[]{new ModLoadedCondition("gateways")});
            AdvancementHolder completeAscentGate = Advancement.Builder.advancement().display(ApothAdvancementProvider.gatePearl(ascentGate), ApothAdvancementProvider.title("challenge_gates.ascent"), ApothAdvancementProvider.desc("challenge_gates.ascent"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("complete_ascent_gate", ProgressionGenerator.completeGateway(ascentGate)).parent(ascent).build(Apotheosis.loc("gateways/ascent"));
            consumer.saveConditionally(completeAscentGate, new ICondition[]{new ModLoadedCondition("gateways")});
            AdvancementHolder completeSummitGate = Advancement.Builder.advancement().display(ApothAdvancementProvider.gatePearl(summitGate), ApothAdvancementProvider.title("challenge_gates.summit"), ApothAdvancementProvider.desc("challenge_gates.summit"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("complete_summit_gate", ProgressionGenerator.completeGateway(summitGate)).parent(summit).build(Apotheosis.loc("gateways/summit"));
            consumer.saveConditionally(completeSummitGate, new ICondition[]{new ModLoadedCondition("gateways")});
            AdvancementHolder completePinnacleGate = Advancement.Builder.advancement().display(ApothAdvancementProvider.gatePearl(pinnacleGate), ApothAdvancementProvider.title("challenge_gates.pinnacle"), ApothAdvancementProvider.desc("challenge_gates.pinnacle"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("complete_pinnacle_gate", ProgressionGenerator.completeGateway(pinnacleGate)).parent(pinnacle).build(Apotheosis.loc("gateways/pinnacle"));
            consumer.saveConditionally(completePinnacleGate, new ICondition[]{new ModLoadedCondition("gateways")});
            AdvancementHolder obtainSigilOfSupremacy = Advancement.Builder.advancement().display((ItemLike)Apoth.Items.SIGIL_OF_SUPREMACY.value(), ApothAdvancementProvider.title("challenge_gates.sigil_of_supremacy"), ApothAdvancementProvider.desc("challenge_gates.sigil_of_supremacy"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.CHALLENGE, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("obtain_sigil_of_supremacy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)Apoth.Items.SIGIL_OF_SUPREMACY.value()})).parent(completePinnacleGate).build(Apotheosis.loc("gateways/sigil_of_supremacy"));
            consumer.saveConditionally(obtainSigilOfSupremacy, new ICondition[]{new ModLoadedCondition("gateways")});
        }

        @SafeVarargs
        private static Criterion<?> rarityInSlot(EquipmentSlotGroup slot, DynamicHolder<LootRarity> ... rarities) {
            return EquippedItemTrigger.TriggerInstance.hasItems(slot, ApothAdvancementProvider.ip(new RarityItemPredicate(ApothMiscUtil.linkedSet(rarities))));
        }

        private static Criterion<?> completeGateway(DynamicHolder<Gateway> gate) {
            return GatewayObjects.FINISH_GATEWAY.createCriterion((CriterionTriggerInstance)new FinishGatewayTrigger.Instance(Optional.empty(), gate));
        }
    }

    private static interface ConditionalConsumer<T>
    extends Consumer<T> {
        public void saveConditionally(T var1, ICondition ... var2);
    }
}

