/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.items;

import appeng.api.config.Actionable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.menuobjects.IPortableTerminal;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.items.contents.PortableCellMenuHost;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.MEStorageMenu;
import com.glodblock.github.appflux.AppFlux;
import com.glodblock.github.appflux.api.IFluxCell;
import com.glodblock.github.appflux.common.AFSingletons;
import com.glodblock.github.appflux.common.me.cell.FECellHandler;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.util.AFUtil;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPortableFECell
extends AbstractPortableCell
implements IFluxCell {
    private final long totalBytes;
    private final double idleDrain;
    private final boolean isMega;
    public static final MenuType<MEStorageMenu> FE_CELL_TYPE = MenuTypeBuilder.create(MEStorageMenu::new, IPortableTerminal.class).buildUnregistered(AppFlux.id("portable_fe_cell"));

    public ItemPortableFECell(int quartKilobytes, double idleDrain, int defaultColor) {
        super(FE_CELL_TYPE, new Item.Properties().stacksTo(1), defaultColor);
        this.totalBytes = (long)quartKilobytes * 256L;
        this.idleDrain = idleDrain;
        this.isMega = quartKilobytes >= 1024;
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)4);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean induct = this.getUpgrades(stack).isInstalled((ItemLike)AFSingletons.INDUCTION_CARD);
            MEStorage storedInv = this.getUsingStorage(player, stack);
            FluxKey key = FluxKey.of(EnergyType.FE);
            if (induct && storedInv != null) {
                Inventory inv = player.getInventory();
                for (int slot = 0; slot < inv.getContainerSize(); ++slot) {
                    long stored = storedInv.getAvailableStacks().get((AEKey)key);
                    if (stored <= 0L) {
                        return;
                    }
                    IEnergyStorage cap = (IEnergyStorage)AFUtil.findCapability(inv.getItem(slot), Capabilities.EnergyStorage.ITEM);
                    if (cap == null || !cap.canReceive()) continue;
                    int toAdd = AFUtil.clampLong(stored);
                    int added = cap.receiveEnergy(toAdd, false);
                    storedInv.extract((AEKey)key, (long)added, Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                }
            }
        }
    }

    private MEStorage getUsingStorage(Player player, ItemStack stack) {
        PortableCellMenuHost cell;
        MEStorageMenu container;
        ITerminalHost iTerminalHost;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof MEStorageMenu && (iTerminalHost = (container = (MEStorageMenu)abstractContainerMenu).getHost()) instanceof PortableCellMenuHost && (cell = (PortableCellMenuHost)iTerminalHost).getItemStack() == stack) {
            return cell.getInventory();
        }
        return FECellHandler.HANDLER.getCellInventory(stack, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        super.appendHoverText(stack, context, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    public ResourceLocation getRecipeId() {
        return AppFlux.id("tools/" + Objects.requireNonNull(this.getRegistryName()).getPath());
    }

    public double getChargeRate(ItemStack stack) {
        return (80.0 + 80.0 * (double)Upgrades.getEnergyCardMultiplier((IUpgradeInventory)this.getUpgrades(stack))) * (double)(this.isMega ? 2 : 1);
    }

    public double getAEMaxPower(ItemStack stack) {
        return super.getAEMaxPower(stack) * (double)(this.isMega ? 8 : 1);
    }

    @Override
    public EnergyType getEnergyType() {
        return EnergyType.FE;
    }

    @Override
    public long getBytes(ItemStack cellItem) {
        return this.totalBytes;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public void addCellInformationToTooltip(ItemStack is, List<Component> lines) {
        Preconditions.checkArgument((is.getItem() == this ? 1 : 0) != 0);
        FECellHandler.HANDLER.addCellInformationToTooltip(is, lines);
    }

    @Override
    public Optional<TooltipComponent> getCellTooltipImage(ItemStack is) {
        return FECellHandler.HANDLER.getTooltipImage(is);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return this.getCellTooltipImage(stack);
    }

    @Nullable
    public IEnergyStorage getCapability(@NotNull ItemStack stack, Void unused) {
        return new PoweredItemCapabilities(stack, (IAEItemPowerStorage)this);
    }
}

