/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.strategy;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.util.AFUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class FEStackExportStrategy
implements StackExportStrategy {
    private final BlockCapabilityCache<? extends IEnergyStorage, Direction> apiCache;

    public FEStackExportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
    }

    public long transfer(StackTransferContext context, AEKey what, long amount) {
        if (!(what instanceof FluxKey)) {
            return 0L;
        }
        IEnergyStorage storage = (IEnergyStorage)this.apiCache.getCapability();
        if (storage == null) {
            return 0L;
        }
        IStorageService inv = context.getInternalStorage();
        long toAdd = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)amount, (IActionSource)context.getActionSource(), (Actionable)Actionable.SIMULATE);
        if ((toAdd = (long)storage.receiveEnergy(AFUtil.clampLong(toAdd), true)) > 0L) {
            int realExt = AFUtil.clampLong(StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)toAdd, (IActionSource)context.getActionSource(), (Actionable)Actionable.MODULATE));
            int realAdd = storage.receiveEnergy(realExt, false);
            if (realAdd < realExt) {
                inv.getInventory().insert(what, (long)(realExt - realAdd), Actionable.MODULATE, context.getActionSource());
            }
            return realAdd;
        }
        return 0L;
    }

    public long push(AEKey what, long amount, Actionable mode) {
        if (!(what instanceof FluxKey)) {
            return 0L;
        }
        IEnergyStorage storage = (IEnergyStorage)this.apiCache.getCapability();
        if (storage == null) {
            return 0L;
        }
        return storage.receiveEnergy(AFUtil.clampLong(amount), mode.isSimulate());
    }
}

