/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.geometry;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.byAqua3.avaritia.geometry.BakedModelRenderer;
import net.byAqua3.avaritia.item.ItemMatterCluster;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaRenderTypes;
import net.byAqua3.avaritia.loader.AvaritiaShaders;
import net.byAqua3.avaritia.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class BakedModelCosmic
extends BakedModelRenderer {
    private final ResourceLocation maskTexture;
    private final boolean isMatterCluster;

    public BakedModelCosmic(BakedModel bakedModel, ResourceLocation maskTexture, boolean isMatterCluster) {
        super(bakedModel);
        this.maskTexture = maskTexture;
        this.isMatterCluster = isMatterCluster;
    }

    @Override
    public void render(ItemStack stack, ItemDisplayContext context, boolean leftHand, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, BakedModel model) {
        RenderType COSMIC_RENDER_TYPE = AvaritiaRenderTypes.COSMIC_RENDER_TYPE;
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer itemRenderer = mc.getItemRenderer();
        TextureAtlas textureAtlas = mc.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
        for (BakedModel bakedModel : model.getRenderPasses(stack, true)) {
            for (RenderType renderType : bakedModel.getRenderTypes(stack, true)) {
                itemRenderer.renderModelLists(bakedModel, stack, packedLight, packedOverlay, poseStack, multiBufferSource.getBuffer(renderType));
            }
        }
        if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
            bufferSource.endBatch();
        }
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaShaders.cosmicInventoryRender || context == ItemDisplayContext.GUI) {
            scale = 100.0f;
        } else {
            yaw = (float)((double)(mc.player.getYRot() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.player.getXRot() * 2.0f) * Math.PI / 360.0));
        }
        AvaritiaShaders.timeUniform.set((float)(mc.level.getGameTime() % Integer.MAX_VALUE));
        AvaritiaShaders.yawUniform.set(yaw);
        AvaritiaShaders.pitchUniform.set(pitch);
        AvaritiaShaders.externalScaleUniform.set(scale);
        AvaritiaShaders.opacityUniform.set(1.0f);
        AvaritiaShaders.cosmicuvsUniform.set(AvaritiaShaders.COSMIC_UVS);
        if (this.isMatterCluster && stack.has((DataComponentType)AvaritiaDataComponents.CLUSTER_CONTAINER.get()) && ItemMatterCluster.getClusterCount(ItemMatterCluster.getClusterItems(stack)) <= 4096) {
            AvaritiaShaders.opacityUniform.set(Float.valueOf(ItemMatterCluster.getClusterCount(ItemMatterCluster.getClusterItems(stack))).floatValue() / Float.valueOf(4096.0f).floatValue());
        }
        TextureAtlasSprite[] textureAtlasSprites = new TextureAtlasSprite[]{textureAtlas.getSprite(this.maskTexture)};
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(COSMIC_RENDER_TYPE);
        itemRenderer.renderQuadList(poseStack, vertexConsumer, RenderUtils.bakeItem(textureAtlasSprites), stack, packedLight, packedOverlay);
    }
}

