/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import net.byAqua3.avaritia.damage.DamageSourceInfinity;
import net.byAqua3.avaritia.loader.AvaritiaTiers;
import net.byAqua3.avaritia.util.ItemUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.neoforged.neoforge.entity.PartEntity;

public class ItemInfinitySword
extends SwordItem {
    public ItemInfinitySword(Item.Properties properties) {
        super((Tier)AvaritiaTiers.INFINITY, properties.attributes(SwordItem.createAttributes((Tier)AvaritiaTiers.INFINITY, (int)2, (float)-2.4f)));
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity entity, LivingEntity attacker) {
        if (entity != null) {
            DamageSourceInfinity damageSource = new DamageSourceInfinity((Entity)attacker);
            if (!entity.level().isClientSide()) {
                if (entity instanceof Player && ItemUtils.isInfinityArmor((Player)entity)) {
                    entity.hurt((DamageSource)damageSource, 4.0f);
                    return true;
                }
                entity.hurt((DamageSource)damageSource, Float.MAX_VALUE);
                entity.setHealth(0.0f);
                entity.die((DamageSource)damageSource);
            }
        }
        return super.hurtEnemy(stack, entity, attacker);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        DamageSourceInfinity damageSource = new DamageSourceInfinity((Entity)player);
        if (!entity.level().isClientSide()) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.getHealth() <= 0.0f) {
                    livingEntity.remove(Entity.RemovalReason.KILLED);
                } else {
                    if (livingEntity instanceof Player && ItemUtils.isInfinityArmor((Player)livingEntity)) {
                        livingEntity.hurt((DamageSource)damageSource, 4.0f);
                        return true;
                    }
                    livingEntity.hurt((DamageSource)damageSource, Float.MAX_VALUE);
                    livingEntity.setHealth(0.0f);
                    livingEntity.die((DamageSource)damageSource);
                }
            } else {
                if (entity instanceof PartEntity) {
                    PartEntity partEntity = (PartEntity)entity;
                    if (partEntity.getParent() instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)partEntity.getParent();
                        livingEntity.hurt((DamageSource)damageSource, Float.MAX_VALUE);
                        livingEntity.getAttribute(Attributes.MAX_HEALTH).setBaseValue(0.0);
                        livingEntity.setHealth(0.0f);
                    } else {
                        partEntity.getParent().hurt((DamageSource)damageSource, Float.MAX_VALUE);
                    }
                    return true;
                }
                entity.hurt((DamageSource)damageSource, Float.MAX_VALUE);
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }
}

