/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.byAqua3.avaritia.entity.EntityInfinityArrow;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class RenderInfinityArrow<T extends EntityInfinityArrow>
extends EntityRenderer<T> {
    public static final ResourceLocation INFINITY_ARROW = ResourceLocation.tryBuild((String)"avaritia", (String)"textures/entity/infinity_arrow.png");

    public RenderInfinityArrow(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EntityInfinityArrow entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        float i = (float)entity.shakeTime - partialTicks;
        if (i > 0.0f) {
            float f2 = -Mth.sin((float)(i * 3.0f)) * i;
            poseStack.mulPose(Axis.ZP.rotationDegrees(f2));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        poseStack.scale(0.05625f, 0.05625f, 0.05625f);
        poseStack.translate(-4.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
        PoseStack.Pose posestack$pose = poseStack.last();
        this.vertex(posestack$pose, vertexconsumer, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, packedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, packedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, packedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, packedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, packedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, packedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, packedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, packedLight);
        for (int j = 0; j < 4; ++j) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.vertex(posestack$pose, vertexconsumer, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, packedLight);
            this.vertex(posestack$pose, vertexconsumer, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, packedLight);
            this.vertex(posestack$pose, vertexconsumer, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, packedLight);
            this.vertex(posestack$pose, vertexconsumer, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, packedLight);
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    public void vertex(PoseStack.Pose pPose, VertexConsumer pConsumer, int pX, int pY, int pZ, float pU, float pV, int normalX, int normalY, int normalZ, int packedLight) {
        pConsumer.addVertex(pPose, (float)pX, (float)pY, (float)pZ).setColor(-1).setUv(pU, pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pPose, (float)normalX, (float)normalZ, (float)normalY);
    }

    public ResourceLocation getTextureLocation(EntityInfinityArrow entity) {
        return INFINITY_ARROW;
    }
}

