/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.widgets;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.gui.api.ISuggestionRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public class SuggestionRenderers {

    public static class ColorEntry
    implements ISuggestionRenderer {
        @Override
        public Component renderSuggestion(GuiGraphics graphics, String value, int x, int y) {
            try {
                graphics.fill(x + 1, y + -1, x + 18, y + 17, -6250336);
                graphics.fill(x + 2, y, x + 17, y + 16, Long.decode(value).intValue() | 0xFF000000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static class PotionEntry
    implements ISuggestionRenderer {
        @Override
        public Component renderSuggestion(GuiGraphics graphics, String value, int x, int y) {
            ResourceLocation id = ResourceLocation.tryParse((String)value);
            if (id == null) {
                return null;
            }
            MobEffect potion = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(id);
            if (potion == null) {
                return null;
            }
            ItemStack item = new ItemStack((ItemLike)Items.POTION);
            item.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.of(potion.getColor()), List.of(new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)potion)))));
            graphics.renderItem(item, x, y);
            return potion.getDisplayName().copy().withStyle(ChatFormatting.YELLOW).append("\n").append((Component)Component.literal((String)id.toString()).withStyle(ChatFormatting.GRAY));
        }
    }

    public static class EnchantmentEntry
    implements ISuggestionRenderer {
        @Override
        public Component renderSuggestion(GuiGraphics graphics, String value, int x, int y) {
            ResourceLocation id = ResourceLocation.tryParse((String)value);
            if (id == null) {
                return null;
            }
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                if (CarbonConfig.SHOW_MISSING_ENCHANTMENT_TEXTURE.get()) {
                    graphics.blit(x, y, 0, 18, 18, (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MissingTextureAtlasSprite.getLocation()));
                    return Component.translatable((String)"gui.carbonconfig.enchantment.missing").withStyle(ChatFormatting.RED);
                }
                return null;
            }
            Holder<Enchantment> holder = this.getEnchantmnetById(level, id);
            if (holder == null) {
                return null;
            }
            Enchantment ench = (Enchantment)holder.value();
            if (ench == null) {
                return null;
            }
            graphics.renderItem(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(holder, ench.getMinLevel())), x, y);
            return Enchantment.getFullname(holder, (int)ench.getMinLevel()).copy().withStyle(ChatFormatting.YELLOW).append("\n").append((Component)Component.literal((String)id.toString()).withStyle(ChatFormatting.GRAY));
        }

        private Holder<Enchantment> getEnchantmnetById(ClientLevel level, ResourceLocation id) {
            try {
                return level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)id));
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class FluidEntry
    implements ISuggestionRenderer {
        @Override
        public Component renderSuggestion(GuiGraphics graphics, String value, int x, int y) {
            ResourceLocation id = ResourceLocation.tryParse((String)value);
            if (id == null) {
                return null;
            }
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(id);
            if (fluid == Fluids.EMPTY || fluid == null) {
                return null;
            }
            TextureAtlasSprite sprite = this.getSprite(fluid);
            if (sprite == null) {
                return null;
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            graphics.blit(x, y, 0, 18, 18, sprite);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return fluid.getFluidType().getDescription().copy().withStyle(ChatFormatting.YELLOW).append("\n").append((Component)Component.literal((String)id.toString()).withStyle(ChatFormatting.GRAY));
        }

        private TextureAtlasSprite getSprite(Fluid fluid) {
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture());
        }
    }

    public static class ItemEntry
    implements ISuggestionRenderer {
        @Override
        public Component renderSuggestion(GuiGraphics graphics, String value, int x, int y) {
            ResourceLocation id = ResourceLocation.tryParse((String)value);
            if (id == null) {
                return null;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (item == Items.AIR || item == null) {
                return null;
            }
            ItemStack itemStack = new ItemStack((ItemLike)item);
            graphics.renderItem(itemStack, x, y);
            return itemStack.getHoverName().copy().withStyle(ChatFormatting.YELLOW).append("\n").append((Component)Component.literal((String)id.toString()).withStyle(ChatFormatting.GRAY));
        }
    }
}

