/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.networking.ICarbonPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class SaveConfigPacket
implements ICarbonPacket {
    public static final StreamCodec<FriendlyByteBuf, SaveConfigPacket> STREAM_CODEC = CustomPacketPayload.codec(SaveConfigPacket::write, ICarbonPacket.readPacket(SaveConfigPacket::new));
    public static final CustomPacketPayload.Type<SaveConfigPacket> ID = ICarbonPacket.createType("carbonconfig:save_carbon");
    String identifier;
    String data;

    public SaveConfigPacket(String identifier, String data) {
        this.identifier = identifier;
        this.data = data;
    }

    public SaveConfigPacket(FriendlyByteBuf buffer) {
        this.identifier = buffer.readUtf(Short.MAX_VALUE);
        this.data = buffer.readUtf(262144);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.identifier, Short.MAX_VALUE);
        buffer.writeUtf(this.data, 262144);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            CarbonConfig.LOGGER.warn("Don't have Permission to Change configs");
            return;
        }
        ConfigHandler handler = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        try {
            ConfigHandler.load(handler, handler.getConfig(), (List<String>)ObjectArrayList.wrap((Object[])this.data.split("\n")), false);
            handler.save();
            CarbonConfig.LOGGER.info("Saved [" + this.identifier + "] Config");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

