/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.plugins.jei.configs;

import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.plugins.jei.configs.JEIArray;
import carbonconfiglib.plugins.jei.configs.JEIHelpers;
import carbonconfiglib.plugins.jei.configs.JEIValue;
import carbonconfiglib.utils.structure.IStructuredData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.runtime.config.IJeiConfigListValueSerializer;
import mezz.jei.api.runtime.config.IJeiConfigValue;
import mezz.jei.api.runtime.config.IJeiConfigValueSerializer;
import mezz.jei.common.config.file.serializers.BooleanSerializer;
import mezz.jei.common.config.file.serializers.EnumSerializer;
import mezz.jei.library.config.serializers.ChatFormattingSerializer;
import mezz.jei.library.config.serializers.ColorNameSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class JEILeaf
implements IConfigNode {
    public static final Map<Class<?>, DataType> KNOWN_TYPES = JEILeaf.createTypes();
    IJeiConfigValue<?> entry;
    IJeiConfigValueSerializer<?> serializer;
    DataType type;
    boolean isArray;
    JEIArray array;
    JEIValue value;

    public JEILeaf(IJeiConfigValue<?> leaf) {
        this.entry = leaf;
        this.serializer = leaf.getSerializer();
        this.isArray = this.serializer instanceof IJeiConfigListValueSerializer;
        this.type = KNOWN_TYPES.getOrDefault(this.isArray ? ((IJeiConfigListValueSerializer)this.serializer).getListValueSerializer().getClass() : this.serializer.getClass(), DataType.STRING);
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public INode asNode() {
        if (this.isArray) {
            if (this.array == null) {
                this.array = new JEIArray(this.getName(), this.getTooltip(), null, this.type, JEIHelpers.getArrayValue(this.entry), JEIHelpers.getArrayDefault(this.entry), () -> JEIHelpers.getSuggestions(this.serializer), T -> JEIHelpers.parse(T, this.serializer), this::save);
            }
            return this.array;
        }
        if (this.value == null) {
            this.value = new JEIValue(this.getName(), this.getTooltip(), null, this.type, JEIHelpers.getValue(this.entry), JEIHelpers.getDefault(this.entry), () -> JEIHelpers.getSuggestions(this.serializer), T -> JEIHelpers.parse(T, this.serializer), (K, V) -> this.save((String)K, (JEIValue)V, (IJeiConfigValue)this.entry));
        }
        return this.value;
    }

    private <T> void save(List<String> result) {
        JEIHelpers.save(result, this.entry);
    }

    private <T> void save(String value, JEIValue entry, IJeiConfigValue<T> result) {
        JEIHelpers.parseValue(value, result.getSerializer(), arg_0 -> result.set(arg_0));
    }

    @Override
    public IStructuredData.StructureType getDataStructure() {
        return this.isArray ? IStructuredData.StructureType.LIST : IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        if (this.value != null && this.value.isChanged()) {
            return true;
        }
        return this.array != null && this.array.isChanged();
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
        if (this.array != null) {
            this.array.save();
        }
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
        if (this.array != null) {
            this.array.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        this.asNode();
        if (this.isArray) {
            this.array.setDefault();
        } else {
            this.value.setDefault();
        }
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public boolean requiresReload() {
        return false;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public Component getName() {
        return this.entry.getLocalizedName();
    }

    @Override
    public Component getTooltip() {
        MutableComponent comp = Component.empty();
        comp.append((Component)this.entry.getLocalizedName().copy().withStyle(ChatFormatting.YELLOW)).append("\n");
        if (this.entry.getLocalizedDescription() != null) {
            comp.append((Component)this.entry.getLocalizedDescription().copy().withStyle(ChatFormatting.GRAY)).append("\n");
        }
        IJeiConfigValueSerializer serializer = this.isArray ? ((IJeiConfigListValueSerializer)this.serializer).getListValueSerializer() : this.serializer;
        comp.append((Component)Component.literal((String)serializer.getValidValuesDescription()).withStyle(ChatFormatting.BLUE));
        return comp;
    }

    private static Map<Class<?>, DataType> createTypes() {
        Object2ObjectOpenHashMap types = new Object2ObjectOpenHashMap();
        types.put(BooleanSerializer.class, DataType.BOOLEAN);
        types.put(ChatFormattingSerializer.INSTANCE.getListValueSerializer().getClass(), DataType.STRING);
        types.put(ColorNameSerializer.class, DataType.STRING);
        types.put(EnumSerializer.class, DataType.ENUM);
        return types;
    }
}

