/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.blocks;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.items.CCubesItems;
import chanceCubes.items.ItemChanceCube;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.tileentities.TileChanceCube;
import chanceCubes.util.GiantCubeUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.StatsRegistry;
import chanceCubes.util.Task;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BlockChanceCube
extends BaseChanceBlock
implements EntityBlock {
    public static final EnumProperty<EnumTexture> TEXTURE = EnumProperty.create((String)"texture", EnumTexture.class);
    public static EnumTexture textureToSet = EnumTexture.DEFAULT;

    public BlockChanceCube() {
        super(BlockChanceCube.getBuilder().lightLevel(state -> ((EnumTexture)((Object)((Object)state.getValue(TEXTURE)))).equals((Object)EnumTexture.HALLOWEEN) ? 2 : 0));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(TEXTURE, (Comparable)((Object)EnumTexture.DEFAULT)));
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TileChanceCube(pos, state);
    }

    public BlockState playerWillDestroy(final @NotNull Level level, final @NotNull BlockPos pos, @NotNull BlockState state, final @NotNull Player player) {
        super.playerWillDestroy(level, pos, state, player);
        BlockEntity be = level.getBlockEntity(pos);
        if (!level.isClientSide() && be instanceof TileChanceCube) {
            final TileChanceCube te = (TileChanceCube)be;
            if (!player.getInventory().getSelected().isEmpty() && player.getInventory().getSelected().getItem().equals(CCubesItems.SILK_PENDANT.get())) {
                ItemStack stackCube = new ItemStack((ItemLike)CCubesItems.CHANCE_CUBE.get(), 1);
                ((ItemChanceCube)stackCube.getItem()).setChance(stackCube, te.isScanned() ? te.getChance() : -101);
                ItemEntity blockStack = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stackCube);
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                level.removeBlockEntity(pos);
                level.addFreshEntity((Entity)blockStack);
                return super.playerWillDestroy(level, pos, state, player);
            }
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            Scheduler.scheduleTask(new Task(this, "reward_delay", 1){

                @Override
                public void callback() {
                    GlobalCCRewardRegistry.DEFAULT.triggerRandomReward((ServerLevel)level, pos, player, te.getChance());
                }
            });
            player.awardStat(StatsRegistry.OPENED_CHANCE_CUBE.get());
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state2, boolean p_60570_) {
        GiantCubeUtil.checkMultiBlockForm(pos, level, true);
        super.onPlace(state, level, pos, state2, p_60570_);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState iBlockState = super.getStateForPlacement(context);
        return (BlockState)iBlockState.setValue(TEXTURE, (Comparable)((Object)textureToSet));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TEXTURE});
    }

    public static enum EnumTexture implements StringRepresentable
    {
        DEFAULT("default"),
        VALENTINES("valentines"),
        STPATRICKS("stpatricks"),
        HALLOWEEN("halloween"),
        HOLIDAYS("holidays"),
        EASTER("easter");

        private final String name;

        private EnumTexture(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

