/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.blocks;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.items.CCubesItems;
import chanceCubes.items.ItemChanceCube;
import chanceCubes.network.PacketTriggerD20;
import chanceCubes.tileentities.TileChanceD20;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.StatsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockChanceD20
extends BaseChanceBlock
implements EntityBlock {
    public BlockChanceD20() {
        super(BlockChanceD20.getBuilder().strength(-1.0f, 2.1474836E9f).lightLevel(state -> 7).noOcclusion());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pBlockEntityType == CCubesBlocks.TILE_CHANCE_ICOSAHEDRON.get() ? TileChanceD20::tick : null;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TileChanceD20(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        TileChanceD20 d20 = (TileChanceD20)pLevel.getBlockEntity(pPos);
        if (d20 != null) {
            double wave = (double)d20.wave * 16.0;
            return Block.box((double)2.0, (double)(0.5 + wave), (double)2.0, (double)14.0, (double)(15.5 + wave), (double)14.0);
        }
        return Block.box((double)2.0, (double)0.5, (double)2.0, (double)14.0, (double)15.5, (double)14.0);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Block.box((double)2.0, (double)0.5, (double)2.0, (double)14.0, (double)15.5, (double)14.0);
    }

    public boolean hasDynamicShape() {
        return true;
    }

    public void attack(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        this.startD20(level, pos, player);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        return this.startD20(level, pos, player) ? InteractionResult.PASS : InteractionResult.FAIL;
    }

    public boolean startD20(Level level, BlockPos pos, Player player) {
        if (level.isClientSide() || player == null) {
            return true;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileChanceD20) {
            TileChanceD20 te = (TileChanceD20)blockEntity;
            if (!player.getInventory().getSelected().isEmpty() && player.getInventory().getSelected().getItem().equals(CCubesItems.SILK_PENDANT.get())) {
                ItemStack stack = new ItemStack((ItemLike)CCubesItems.CHANCE_ICOSAHEDRON.get(), 1);
                ((ItemChanceCube)stack.getItem()).setChance(stack, te.isScanned() ? te.getChance() : -101);
                BlockChanceD20.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                level.removeBlockEntity(pos);
                return false;
            }
            RewardsUtil.executeCommand((ServerLevel)level, player, (Vec3i)player.getOnPos(), "/advancement grant @p only chancecubes:chance_icosahedron");
            player.awardStat(StatsRegistry.OPENED_D20.get());
            te.startBreaking(player);
            PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)level), null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)50.0, (CustomPacketPayload)new PacketTriggerD20(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return false;
    }
}

