/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.containers;

import chanceCubes.containers.CCubesMenus;
import chanceCubes.items.CCubesItems;
import chanceCubes.items.ItemChanceCube;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CreativePendantContainer
extends AbstractContainerMenu {
    private final Container pendantSlot = new SimpleContainer(this, 1){

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return stack.getItem() instanceof ItemChanceCube;
        }
    };

    public CreativePendantContainer(int windowId, Inventory inv) {
        super((MenuType)CCubesMenus.CREATIVE_PENDANT_CONTAINER.get(), windowId);
        this.addSlot(new Slot(this, this.pendantSlot, 0, 80, 50){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof ItemChanceCube;
            }
        });
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)inv, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)inv, l, 8 + l * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        Slot slotObject = this.getSlot(slot);
        if (slotObject.getItem().isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = slotObject.getItem();
        ItemStack stack = stackInSlot.copy();
        if (slot > 35) {
            if (!this.moveItemStackTo(stackInSlot, 0, 36, true)) {
                return ItemStack.EMPTY;
            }
            if (stack.getItem().equals(CCubesItems.CHANCE_CUBE.get()) && !this.moveItemStackTo(stackInSlot, 36, 37, true)) {
                return ItemStack.EMPTY;
            }
        }
        if (stackInSlot.getCount() == 0) {
            slotObject.set(ItemStack.EMPTY);
        } else {
            slotObject.setChanged();
        }
        if (stackInSlot.getCount() == stack.getCount()) {
            return ItemStack.EMPTY;
        }
        slotObject.onTake(player, stackInSlot);
        return stack;
    }

    public void removed(Player player) {
        ItemStack itemstack;
        super.removed(player);
        if (!player.level().isClientSide() && !(itemstack = this.pendantSlot.getItem(0)).isEmpty()) {
            player.drop(itemstack, false);
        }
    }

    public ItemStack getChanceCubesInPendant() {
        return this.pendantSlot.getItem(0);
    }
}

