/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;

public class ItemChestReward
extends BaseCustomReward {
    private final ItemStack[] stacks = new ItemStack[]{new ItemStack((ItemLike)Blocks.GLASS), new ItemStack((ItemLike)Items.APPLE), new ItemStack((ItemLike)Items.BREAD), new ItemStack((ItemLike)Items.CAKE), new ItemStack((ItemLike)Items.COOKIE), new ItemStack((ItemLike)Items.COOKED_BEEF), new ItemStack((ItemLike)Items.DIAMOND), new ItemStack((ItemLike)Items.EGG), new ItemStack((ItemLike)Items.FEATHER), new ItemStack((ItemLike)Items.GOLD_INGOT), new ItemStack((ItemLike)Items.IRON_SWORD), new ItemStack((ItemLike)Items.LEATHER), new ItemStack((ItemLike)Items.EMERALD), new ItemStack((ItemLike)Items.MELON), new ItemStack((ItemLike)Items.OAK_DOOR), new ItemStack((ItemLike)Items.PAPER), new ItemStack((ItemLike)Items.POTATO), new ItemStack((ItemLike)Items.PUMPKIN_PIE), new ItemStack((ItemLike)Items.QUARTZ), new ItemStack((ItemLike)Items.MUSIC_DISC_13), new ItemStack((ItemLike)Items.REDSTONE), new ItemStack((ItemLike)Items.SUGAR_CANE), new ItemStack((ItemLike)Items.OAK_SIGN), new ItemStack((ItemLike)Items.SLIME_BALL), new ItemStack((ItemLike)Items.SNOWBALL), new ItemStack((ItemLike)Items.SPIDER_EYE), new ItemStack((ItemLike)Items.WHEAT), new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), new ItemStack((ItemLike)Items.CLAY_BALL), new ItemStack((ItemLike)Items.BLAZE_ROD), new ItemStack((ItemLike)Items.ENDER_PEARL)};

    public ItemChestReward() {
        super("chancecubes:item_chest", 25);
    }

    @Override
    public void trigger(final ServerLevel world, final BlockPos pos, final Player player, JsonObject settings) {
        world.setBlockAndUpdate(pos, Blocks.CHEST.defaultBlockState());
        final ChestBlockEntity chest = (ChestBlockEntity)world.getBlockEntity(pos);
        Scheduler.scheduleTask(new Task("Item_Chest_Init_Delay", 60){

            @Override
            public void callback() {
                ItemChestReward.this.spawnItems(world, pos, chest);
                chest.startOpen(player);
            }
        });
    }

    public void spawnItems(final ServerLevel world, final BlockPos pos, ChestBlockEntity chest) {
        Scheduler.scheduleTask(new Task("Item_Chest_Squids", 250, 5){

            @Override
            public void callback() {
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }

            @Override
            public void update() {
                ItemEntity item = new ItemEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ(), ItemChestReward.this.stacks[RewardsUtil.rand.nextInt(ItemChestReward.this.stacks.length)].copy());
                world.addFreshEntity((Entity)item);
                item.setDeltaMovement(0.0, 1.5, RewardsUtil.rand.nextDouble() * -2.0 - 1.0);
                item.setPickUpDelay(60);
            }
        });
    }
}

