/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ChunkReverserReward
extends BaseCustomReward {
    private final List<Map.Entry<Block, Block>> swappedMap = new ArrayList<Map.Entry<Block, Block>>();

    public ChunkReverserReward() {
        super("chancecubes:chuck_reverse", 0);
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.DIRT, Blocks.COBBLESTONE));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.STONE, Blocks.DIRT));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.GRASS_BLOCK, Blocks.STONE));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.GRAVEL, Blocks.SAND));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.SAND, Blocks.GRAVEL));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.IRON_ORE, Blocks.GOLD_ORE));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.COAL_ORE, Blocks.DIAMOND_ORE));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.DIAMOND_ORE, Blocks.COAL_ORE));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.GOLD_ORE, Blocks.IRON_ORE));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.LAVA, Blocks.WATER));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.WATER, Blocks.LAVA));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.ACACIA_LOG, Blocks.ACACIA_LEAVES));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.ACACIA_LEAVES, Blocks.ACACIA_LOG));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.DARK_OAK_LOG, Blocks.DARK_OAK_LEAVES));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.DARK_OAK_LEAVES, Blocks.DARK_OAK_LOG));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.OAK_LOG, Blocks.OAK_LEAVES));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.OAK_LEAVES, Blocks.OAK_LOG));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.BIRCH_LOG, Blocks.BIRCH_LEAVES));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.BIRCH_LEAVES, Blocks.BIRCH_LOG));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.JUNGLE_LOG, Blocks.JUNGLE_LEAVES));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.JUNGLE_LEAVES, Blocks.JUNGLE_LOG));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.SPRUCE_LOG, Blocks.SPRUCE_LEAVES));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.SPRUCE_LEAVES, Blocks.SPRUCE_LOG));
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
        RewardsUtil.sendMessageToPlayer(player, "Initiating Block Inverter");
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        int delay = 0;
        for (int yy = 256; yy > 0; --yy) {
            int xx = 0;
            int zz = 0;
            int dx = 0;
            int dy = -1;
            int t = 16;
            int maxI = t * t;
            for (int i = 0; i < maxI; ++i) {
                if (-8 <= xx && xx <= 8 && -8 <= zz && zz <= 8) {
                    Block blockAt = level.getBlockState(new BlockPos(pos.getX() + xx, yy, pos.getZ() + zz)).getBlock();
                    Block toSwapTo = null;
                    for (Map.Entry<Block, Block> blockSwap : this.swappedMap) {
                        if (!blockSwap.getKey().equals(blockAt)) continue;
                        toSwapTo = blockSwap.getValue();
                    }
                    if (toSwapTo != null) {
                        blocks.add(new OffsetBlock(xx, yy - pos.getY(), zz, toSwapTo, false, delay / 5));
                        ++delay;
                    }
                }
                if (xx == zz || xx < 0 && xx == -zz || xx > 0 && xx == 1 - zz) {
                    t = dx;
                    dx = -dy;
                    dy = t;
                }
                xx += dx;
                zz += dy;
            }
        }
        RewardsUtil.sendMessageToPlayer(player, "Inverting " + blocks.size() + " Blocks... May take a minute...");
        for (OffsetBlock b : blocks) {
            b.spawnInWorld((Level)level, pos.getX(), pos.getY(), pos.getZ());
        }
    }
}

