/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardtype;

import chanceCubes.rewards.rewardparts.PotionPart;
import chanceCubes.rewards.rewardtype.BaseRewardType;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PotionRewardType
extends BaseRewardType<PotionPart> {
    public PotionRewardType(PotionPart ... effects) {
        super(effects);
    }

    @Override
    public void trigger(final PotionPart part, final ServerLevel level, int x, int y, int z, final Player player) {
        Scheduler.scheduleTask(new Task(this, "Potion Reward Delay", part.getDelay()){

            @Override
            public void callback() {
                ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
                effects.add(part.getEffect());
                ThrownPotion entity = new ThrownPotion((Level)level, (LivingEntity)player);
                ItemStack stack = new ItemStack((ItemLike)Items.SPLASH_POTION);
                for (MobEffectInstance effect : effects) {
                    stack.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).withEffectAdded(effect));
                }
                entity.setItem(stack);
                entity.moveTo(player.getX(), player.getY() + 2.0, player.getZ());
                entity.setDeltaMovement(0.0, 0.1, 0.0);
                level.addFreshEntity((Entity)entity);
            }
        });
    }
}

