/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public class UnlockData {
    public final Map<UUID, List<UUID>> unlockedLocks = new HashMap<UUID, List<UUID>>();

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<UUID, List<UUID>> entry : this.unlockedLocks.entrySet()) {
            ListTag locksList = new ListTag();
            for (UUID lockUUID : entry.getValue()) {
                locksList.add((Object)NbtUtils.createUUID((UUID)lockUUID));
            }
            tag.put(entry.getKey().toString(), (Tag)locksList);
        }
        return tag;
    }

    public static UnlockData fromNbt(CompoundTag tag) {
        UnlockData data = new UnlockData();
        for (String key : tag.getAllKeys()) {
            UUID playerUUID = UUID.fromString(key);
            ArrayList lockUUIDs = new ArrayList();
            ListTag locksList = tag.getList(key, 11);
            locksList.forEach(lockUUID -> lockUUIDs.add(NbtUtils.loadUUID((Tag)lockUUID)));
            data.unlockedLocks.put(playerUUID, lockUUIDs);
        }
        return data;
    }
}

