/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.network.packet;

import dev.architectury.networking.NetworkManager;
import it.hurts.octostudios.octolib.module.network.Packet;
import it.hurts.shatterbyte.clavis.common.ClavisClient;
import it.hurts.shatterbyte.clavis.common.client.screen.LockpickingScreen;
import it.hurts.shatterbyte.clavis.common.data.Lock;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class OpenLockpickingPacket
extends Packet {
    public static final CustomPacketPayload.Type<OpenLockpickingPacket> TYPE = Packet.createType((String)"clavis", (String)"lockpicking_packet");
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenLockpickingPacket> STREAM_CODEC = Packet.createCodec(OpenLockpickingPacket::write, OpenLockpickingPacket::new);
    BlockPos blockPos;
    Lock lock;

    public OpenLockpickingPacket(RegistryFriendlyByteBuf buf) {
        this.blockPos = buf.readBlockPos();
        this.lock = (Lock)buf.readJsonWithCodec(Lock.CODEC);
    }

    public OpenLockpickingPacket(BlockPos blockPos, Lock lock) {
        this.blockPos = blockPos;
        this.lock = lock;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeJsonWithCodec(Lock.CODEC, (Object)this.lock);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void handleClient(NetworkManager.PacketContext packetContext) {
        if (Minecraft.getInstance().screen instanceof LockpickingScreen) {
            return;
        }
        packetContext.queue(() -> ClavisClient.openScreen(this.lock, this.blockPos));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

