/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.sprite.Material;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiProgressIcon
extends GuiElement<GuiProgressIcon>
implements BackgroundRender {
    private Supplier<Material> background = null;
    private Supplier<Material> animated;
    private Supplier<Double> progress = () -> 0.0;
    private boolean rotateToDirection = true;
    private Direction direction = Direction.RIGHT;

    public GuiProgressIcon(@NotNull GuiParent<?> parent, Supplier<Material> animated) {
        super(parent);
        this.animated = animated;
    }

    public GuiProgressIcon(@NotNull GuiParent<?> parent, Material animated) {
        this(parent, () -> animated);
    }

    public GuiProgressIcon(@NotNull GuiParent<?> parent, Supplier<Material> background, Supplier<Material> animated) {
        super(parent);
        this.background = background;
        this.animated = animated;
    }

    public GuiProgressIcon(@NotNull GuiParent<?> parent, Material background, Material animated) {
        this(parent, () -> background, () -> animated);
    }

    public GuiProgressIcon(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiProgressIcon setRotateToDirection(boolean rotateToDirection) {
        this.rotateToDirection = rotateToDirection;
        return this;
    }

    public GuiProgressIcon setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public GuiProgressIcon setBackground(@Nullable Material background) {
        this.background = () -> background;
        return this;
    }

    public GuiProgressIcon setBackground(@Nullable Supplier<Material> background) {
        this.background = background;
        return this;
    }

    public GuiProgressIcon setAnimated(Material animated) {
        this.animated = () -> animated;
        return this;
    }

    public GuiProgressIcon setAnimated(Supplier<Material> animated) {
        this.animated = animated;
        return this;
    }

    public GuiProgressIcon setProgress(double progress) {
        return this.setProgress(() -> progress);
    }

    public GuiProgressIcon setProgress(Supplier<Double> progress) {
        this.progress = progress;
        return this;
    }

    public double getProgress() {
        return this.progress.get();
    }

    @Override
    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.rotateToDirection) {
            render.pose().pushPose();
            double width = this.direction.getAxis() == Axis.X ? this.xSize() : this.ySize();
            double height = this.direction.getAxis() == Axis.X ? this.ySize() : this.xSize();
            render.pose().translate(this.xMin() + this.xSize() / 2.0, this.yMin() + this.ySize() / 2.0, 0.0);
            render.pose().mulPose(com.mojang.math.Axis.ZP.rotationDegrees((float)Direction.RIGHT.rotationTo(this.direction)));
            double halfWidth = width / 2.0;
            double halfHeight = height / 2.0;
            if (this.background != null && this.background.get() != null) {
                render.tex(this.background.get(), -halfWidth, -halfHeight, halfWidth, halfHeight, -1);
            }
            if (this.animated == null || this.animated.get() == null) {
                return;
            }
            float progress = (float)this.getProgress();
            render.partialSprite(this.animated.get().renderType(GuiRender::texColType), -halfWidth, -halfHeight, -halfWidth + width * (double)progress, -halfHeight + height, this.animated.get().sprite(), 0.0f, 0.0f, progress, 1.0f, -1);
            render.pose().popPose();
        } else {
            if (this.background != null && this.background.get() != null) {
                render.texRect(this.background.get(), this.getRectangle());
            }
            if (this.animated == null || this.animated.get() == null) {
                return;
            }
            float progress = (float)this.getProgress();
            switch (this.direction) {
                case UP: {
                    render.partialSprite(this.animated.get().renderType(GuiRender::texColType), this.xMin(), this.yMax() - this.ySize() * (double)progress, this.xMax(), this.yMax(), this.animated.get().sprite(), 0.0f, 1.0f - progress, 1.0f, 1.0f, -1);
                    break;
                }
                case LEFT: {
                    render.partialSprite(this.animated.get().renderType(GuiRender::texColType), this.xMax() - this.xSize() * (double)progress, this.yMin(), this.xMax(), this.yMax(), this.animated.get().sprite(), 1.0f - progress, 0.0f, 1.0f, 1.0f, -1);
                    break;
                }
                case DOWN: {
                    render.partialSprite(this.animated.get().renderType(GuiRender::texColType), this.xMin(), this.yMin(), this.xMax(), this.yMin() + this.ySize() * (double)progress, this.animated.get().sprite(), 0.0f, 0.0f, 1.0f, progress, -1);
                    break;
                }
                case RIGHT: {
                    render.partialSprite(this.animated.get().renderType(GuiRender::texColType), this.xMin(), this.yMin(), this.xMin() + this.xSize() * (double)progress, this.yMax(), this.animated.get().sprite(), 0.0f, 0.0f, progress, 1.0f, -1);
                }
            }
        }
    }
}

